% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pprimarycensored.R
\name{pprimarycensored}
\alias{pprimarycensored}
\alias{ppcens}
\title{Compute the primary event censored CDF for delays}
\usage{
pprimarycensored(
  q,
  pdist,
  pwindow = 1,
  D = Inf,
  dprimary = stats::dunif,
  dprimary_args = list(),
  pdist_name = lifecycle::deprecated(),
  dprimary_name = lifecycle::deprecated(),
  ...
)

ppcens(
  q,
  pdist,
  pwindow = 1,
  D = Inf,
  dprimary = stats::dunif,
  dprimary_args = list(),
  pdist_name = lifecycle::deprecated(),
  dprimary_name = lifecycle::deprecated(),
  ...
)
}
\arguments{
\item{q}{Vector of quantiles}

\item{pdist}{Distribution function (CDF). The package can identify base R
distributions for potential analytical solutions. For non-base R functions,
users can apply \code{\link[=add_name_attribute]{add_name_attribute()}} to yield properly tagged
functions if they wish to leverage the analytical solutions.}

\item{pwindow}{Primary event window}

\item{D}{Maximum delay (truncation point). If finite, the distribution is
truncated at D. If set to Inf, no truncation is applied. Defaults to Inf.}

\item{dprimary}{Function to generate the probability density function
(PDF) of primary event times. This function should take a value \code{x} and a
\code{pwindow} parameter, and return a probability density. It should be
normalized to integrate to 1 over [0, pwindow]. Defaults to a uniform
distribution over [0, pwindow]. Users can provide custom functions or use
helper functions like \code{dexpgrowth} for an exponential growth distribution.
See \code{primary_dists.R} for examples. The package can identify base R
distributions for potential analytical solutions. For non-base R functions,
users can apply \code{\link[=add_name_attribute]{add_name_attribute()}} to yield properly tagged
functions if they wish to leverage analytical solutions.}

\item{dprimary_args}{List of additional arguments to be passed to
dprimary. For example, when using \code{dexpgrowth}, you would
pass \code{list(min = 0, max = pwindow, r = 0.2)} to set the minimum, maximum,
and rate parameters}

\item{pdist_name}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} this argument will be
ignored in future versions; use \code{\link[=add_name_attribute]{add_name_attribute()}} on \code{pdist}
instead}

\item{dprimary_name}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} this argument will be
ignored in future versions; use \code{\link[=add_name_attribute]{add_name_attribute()}} on \code{dprimary}
instead}

\item{...}{Additional arguments to be passed to pdist}
}
\value{
Vector of primary event censored CDFs, normalized by D if finite
(truncation adjustment)
}
\description{
This function computes the primary event censored cumulative distribution
function (CDF) for a given set of quantiles. It adjusts the CDF of the
primary event distribution by accounting for the delay distribution and
potential truncation at a maximum delay (D). The function allows for
custom primary event distributions and delay distributions.
}
\details{
The primary event censored CDF is computed by integrating the product of
the delay distribution function (CDF) and the primary event distribution
function (PDF) over the primary event window. The integration is adjusted
for truncation if a finite maximum delay (D) is specified.

The primary event censored CDF, \eqn{F_{\text{cens}}(q)}, is given by:
\deqn{
F_{\text{cens}}(q) = \int_{0}^{pwindow} F(q - p) \cdot f_{\text{primary}}(p)
\, dp
}
where \eqn{F} is the CDF of the delay distribution,
\eqn{f_{\text{primary}}} is the PDF of the primary event times, and
\eqn{pwindow} is the primary event window.

If the maximum delay \eqn{D} is finite, the CDF is normalized by dividing
by \eqn{F_{\text{cens}}(D)}:
\deqn{
F_{\text{cens,norm}}(q) = \frac{F_{\text{cens}}(q)}{F_{\text{cens}}(D)}
}
where \eqn{F_{\text{cens,norm}}(q)} is the normalized CDF.

This function creates a \code{primarycensored} object using
\code{\link[=new_pcens]{new_pcens()}} and then computes the primary event
censored CDF using \code{\link[=pcens_cdf]{pcens_cdf()}}. This abstraction allows
for automatic use of analytical solutions when available, while
seamlessly falling back to numerical integration when necessary.

See \code{methods(pcens_cdf)} for which combinations have analytical
solutions implemented.
}
\examples{
# Example: Lognormal distribution with uniform primary events
pprimarycensored(c(0.1, 0.5, 1), plnorm, meanlog = 0, sdlog = 1)

# Example: Lognormal distribution with exponential growth primary events
pprimarycensored(
  c(0.1, 0.5, 1), plnorm,
  dprimary = dexpgrowth,
  dprimary_args = list(r = 0.2), meanlog = 0, sdlog = 1
)
}
\seealso{
\code{\link[=new_pcens]{new_pcens()}} and \code{\link[=pcens_cdf]{pcens_cdf()}}

Primary event censored distribution functions
\code{\link{dprimarycensored}()},
\code{\link{rprimarycensored}()}
}
\concept{primarycensored}
