% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictsr.R
\name{GetSitelevelSummaries}
\alias{GetSitelevelSummaries}
\title{Get the PREDICTS database site level summaries.}
\usage{
GetSitelevelSummaries(extract = c(2016, 2022))
}
\arguments{
\item{extract}{Numeric, year/s corresponding to PREDICTS database releases to
download. Options are 2016 or 2022. Defaults to \code{c(2016, 2022)} - the whole
dataset.}
}
\value{
The site-level summary data as a dataframe.
}
\description{
This acesses summary data for the relevant PREDICTS database extract. There
are two releases of the PREDICTS database, an initial release in 2016, and an
additional release in 2022. The user chooses whether to pull summary data for
the 2016 and/or 2022 release.
}
\examples{
\donttest{
  summaries <- GetSitelevelSummaries()
  summaries_2016 <- GetSitelevelSummaries(extract = 2016)
}

}
