% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{get_monte_carlo_se}
\alias{get_monte_carlo_se}
\alias{get_monte_carlo_se.plcp_power_3lvl}
\alias{get_monte_carlo_se.plcp_power_2lvl}
\title{Calculate the Monte Carlo standard error of the empirical power estimates}
\usage{
get_monte_carlo_se(object, nsim, power, ...)

\method{get_monte_carlo_se}{plcp_power_3lvl}(object, nsim, ...)

\method{get_monte_carlo_se}{plcp_power_2lvl}(object, nsim, ...)
}
\arguments{
\item{object}{An object created by \code{\link{get_power}}}

\item{nsim}{A \code{numeric} indicating the number of simulations}

\item{power}{\emph{Optional}. A \code{numeric} indicating the empirical power.}

\item{...}{Currently not used.
Used when \code{object} is \code{NULL}.}
}
\value{
A \code{data.frame} with the estimated power, expected standard error
 of the simulated power estimate, and the 95 \% CI of the estimate.
}
\description{
Returns the expected simulation error for a study design. Indicates how many
simulation that are needed for a desired precision in the empirical power
estimates.
}
\examples{
paras <- study_parameters(n1 = 11,
                          n2 = 10,
                          n3 = 6,
                          T_end = 10,
                          icc_pre_subject = 0.5,
                          icc_pre_cluster = 0,
                          var_ratio = 0.03,
                          icc_slope = 0.05,
                          cohend = -0.8)

x <- get_power(paras)
get_monte_carlo_se(x, nsim = 1000)

# Without an object
get_monte_carlo_se(power = 0.8, nsim = 1000)
}
