% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rounding.R
\name{rounding}
\alias{rounding}
\title{Rounding Function}
\usage{
rounding(buildings, buildpop, blockpop, blockcode)
}
\arguments{
\item{buildings}{object of class \code{sf}}

\item{buildpop}{string of building pop column}

\item{blockpop}{string of block pop column}

\item{blockcode}{string of block id column}
}
\value{
an object of class \code{sf} including rounded population counts
}
\description{
This function converts decimal population estimates produced either by the \link[populR]{areametric} or the \link[populR]{volumetric} approach into integer numbers that sum up to the source zone population counts
}
\examples{
    library(populR)
    data("buildings")
    data("blocks")

    # areametric
    population_a = areametric(buildings = buildings, blocks = blocks,
        code = 'code', pop = 'pop', area = 'area')
    population_ar = rounding(buildings = population_a, buildpop = 'popEst',
        blockpop = 'pop', blockcode = 'code')

    # volumetric
    population_v = volumetric(buildings = buildings, blocks = blocks,
        code = 'code', pop = 'pop', area = 'area', floors = 'floors')
    population_vr = rounding(buildings = population_v, buildpop = 'popEst',
        blockpop = 'pop', blockcode = 'code')

}
