% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4classes.R, R/partition_bundle.R, R/enrich.R,
%   R/s_attributes.R, R/utils.R
\docType{class}
\name{partition_bundle-class}
\alias{partition_bundle-class}
\alias{[,partition_bundle-method}
\alias{[[,partition_bundle-method}
\alias{as.matrix,partition_bundle-method}
\alias{merge,partition_bundle-method}
\alias{+,partition_bundle-method}
\alias{names,partition_bundle-method}
\alias{summary,partition_bundle-method}
\alias{+,partition_bundle,ANY-method}
\alias{[,partition_bundle,ANY,ANY,ANY-method}
\alias{+,partition_bundle,partition-method}
\alias{+,partition_bundle,partition_bundle-method}
\alias{as.partition_bundle,list-method}
\alias{barplot,partition_bundle-method}
\alias{show,partition_bundle-method}
\alias{summary,partition_bundle-method}
\alias{merge,partition_bundle-method}
\alias{[,partition_bundle,ANY,ANY,ANY-method}
\alias{barplot,partition_bundle-method}
\alias{as.partition_bundle,list-method}
\alias{partition_bundle,environment-method}
\alias{enrich,partition_bundle-method}
\alias{s_attributes,partition_bundle-method}
\alias{flatten}
\title{Bundle of partitions (partition_bundle class).}
\usage{
\S4method{show}{partition_bundle}(object)

\S4method{summary}{partition_bundle}(object)

\S4method{merge}{partition_bundle}(x, name = "", verbose = TRUE)

\S4method{[}{partition_bundle,ANY,ANY,ANY}(x, i)

\S4method{barplot}{partition_bundle}(height, ...)

\S4method{as.partition_bundle}{list}(.Object, ...)

\S4method{partition_bundle}{environment}(.Object)

\S4method{enrich}{partition_bundle}(.Object, mc = FALSE, progress = TRUE,
  verbose = FALSE, ...)

\S4method{s_attributes}{partition_bundle}(.Object, s_attribute, ...)

flatten(object)
}
\arguments{
\item{object}{a \code{partition_bundle} object}

\item{x}{a \code{partition_bundle} object}

\item{name}{the name for the new partition}

\item{verbose}{logical}

\item{i}{integer index}

\item{height}{height}

\item{...}{further parameters}

\item{.Object}{a \code{partition_bundle} object}

\item{mc}{logical or, if numeric, providing the number of cores}

\item{progress}{logical}

\item{s_attribute}{the s-attribute to use}
}
\value{
An object of the class 'partition. See partition for the
details on the class.

a \code{partition_bundle} object
}
\description{
Class and methods to manage bundles of partitions.

\code{flatten} may be useful if you have a list of \code{partition_bundle} objects. This function will flatten the data
structure and return a \code{partition_bundle} object.
}
\details{
The \code{merge}-method aggregates several partitions into one partition. The
prerequisite for this function to work properly is that there are no
overlaps of the different partitions that are to be summarized.
Encodings and the root node need to be identical, too.

Using brackets can be used to retrieve the count for a token from the 
\code{partition} objects in a \code{partition_bundle}.
}
\section{Slots}{

\describe{
\item{\code{objects}}{Object of class \code{list} the partitions making up the bundle}

\item{\code{corpus}}{Object of class \code{character} the CWB corpus the partition is based on}

\item{\code{s_attributes_fixed}}{Object of class \code{list} fixed s-attributes}

\item{\code{encoding}}{Object of class \code{character} encoding of the corpus}

\item{\code{explanation}}{Object of class \code{character} an explanation of the partition}

\item{\code{xml}}{Object of class \code{character} whether the xml is flat or nested}

\item{\code{call}}{Object of class \code{character} the call that generated the \code{partition_bundle}}
}}

\author{
Andreas Blaette
}
