% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_podr.R
\name{read_podr}
\alias{read_podr}
\title{Read a dataset from PODR}
\usage{
read_podr(
  dataset = NULL,
  libname = NULL,
  tabname = NULL,
  con = getOption("podr_connection"),
  query_string = NULL,
  limit = 100
)
}
\arguments{
\item{dataset}{Dataset name, specified as a character string}

\item{libname}{Library name, one of cdisc_pilot_adam, cdisc_pilot_sdtm, or janssen_synthetic}

\item{tabname}{Full table name, i.e., the combination of libname and dataset}

\item{con}{The connection to PODR. Use connect_podr to establish a connection, or specify a variable
containing the proper PostgreSQL connection into PODR yourself}

\item{query_string}{provides full SQL statement}

\item{limit}{to select specified number of records; defaults to 100}
}
\value{
The desired dataset as a data.frame
}
\description{
This function will properly query PODR for datasets. There are three "libraries" available to read from:
- CDISC Pilot ADaM data (PHUSE TDF Project 2019 cut)
- CDISC Pilot SDTM data (PHUSE TDF Project 2019 cut)
- Janssen Synthetic SDTM data
}
\details{
Read data by specifying your desired dataset as a character string, then
specify the library you'd like to read from. The libnames are specified as
- cdisc_pilot_adam
- cdisc_pilot_sdtm
- janssen_synthetic
}
\examples{
\dontrun{
conn_podr()
read_podr('adae', libname='cdisc_pilot_adam')
read_podr('ae', libname='cdisc_pilot_sdtm')
read_podr('ae', libname='janssen_synthetic')
}

}
\author{
Hanming Tu
}
