% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palettes.R
\name{plotPals}
\alias{plotPals}
\title{Return all or selected color palettes}
\usage{
plotPals(pal = NULL, alpha = 1)
}
\arguments{
\item{pal}{Name of the palette(s) to return}

\item{alpha}{Control transparency - set alpha channel to alpha (0 -
fully transparent, 1 - fully opaque)}
}
\value{
Either a list of palettes, or (if only one palette was selected)
        a character vector with colors
}
\description{
Return all or selected color palettes from the plotwidget palette set
}
\details{
The plotwidgets package contains a number of predefined palettes,
different from those in RColorBrewer.

\itemize{
 \item \code{default}: a standard, relatively safe (see below) palette 
 \item \code{safe}:  safe for color blind persons, based
               on Wang B. "Points of view: Color blindeness", Nature Methods 8, 441(2011)
 \item \code{neon}: a bright palette suitable for drawing on dark backgrounds
 \item \code{pastel}: a dimmed pastel palette
 \item \code{haze}: very delicate pastel colors
 \item \code{dark}: same hues as haze, but much darker
 \item \code{grey}: different shades of grey
 \item \code{alphabet}: based on "A colour alphabet..." by Paul Green-Armytage
 \item \code{few}: a palette based on Stephen Few's book
 \item \code{zeileis}: based on Zeileis et al. 2009
 \item \code{vizi}: automatically generated palette
}

\if{html}{\figure{palettes.svg}{options: width=800 alt="List of palettes"}}
\if{latex}{\figure{palettes.pdf}{options: width=5.5in}}

You can get all the names of palettes with names(plotPals()), and
showcase them with showPalettes(). Furthermore, you can use the
\code{pal} parameter to \code{\link{plotwidgetGallery}} to see how this
palette looks like with different plot widgets.
}
\examples{
safe <- plotPals("safe") # colorblind-safe palette
plotwidgetGallery(pal=safe)
}
\seealso{
\code{\link{col2rgb.2}}, \code{\link{rgb2col}},
         \code{\link{hsl2col}}, \code{\link{col2hsl}},
         \code{\link{modCol}}, \code{\link{modhueCol}}, \code{\link{darkenCol}}, \code{\link{saturateCol}}
}

