% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fahrenheit.R
\name{f_k}
\alias{f_k}
\alias{f_c}
\title{Convert to Fahrenheit scale}
\usage{
f_k(x)

f_c(x)
}
\arguments{
\item{x}{temperature in initial scale:
\itemize{
  \item for \code{f_k(x)} - in \href{https://en.wikipedia.org/wiki/Kelvin}{Kelvin}-scale, [\emph{K}]
  \item for \code{f_c(x)} - in \href{https://en.wikipedia.org/wiki/Celsius}{Celsius}-scale, [\emph{°C}]
}
Type: \code{\link{assert_double}}.}
}
\value{
temperature in \emph{Fahrenheit}-scale, [\emph{°F}]. Type: \code{\link{assert_double}}.
}
\description{
Convert temperature measured in
 \href{https://en.wikipedia.org/wiki/Kelvin}{Kelvin}- or
 \href{https://en.wikipedia.org/wiki/Celsius}{Celsius}-scale
 to \href{https://en.wikipedia.org/wiki/Fahrenheit}{Fahrenheit} (\emph{°F}).
}
\examples{
 library(pipenostics)

# Convert from Kelvin to Fahrenheit:
f_k(c(0, 373.15))
# [1]  -459.67 212

# Convert from Celsius to Fahrenheit:
f_c(c(-273.15, 100))
# [1]  -459.67, 212

}
\seealso{
\code{\link{k_f}} and \code{\link{c_f}} for converting from Fahrenheit-scale.

Other units: 
\code{\link{c_k}()},
\code{\link{inch_mm}()},
\code{\link{k_c}()},
\code{\link{kgf_mpa}()},
\code{\link{loss_flux}()},
\code{\link{mm_inch}()},
\code{\link{mpa_kgf}()},
\code{\link{mpa_psi}()},
\code{\link{psi_mpa}()}
}
\concept{units}
