% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pb_list.R
\name{pb_list}
\alias{pb_list}
\title{List all assets attached to a release}
\usage{
pb_list(repo = guess_repo(), tag = NULL, .token = gh::gh_token())
}
\arguments{
\item{repo}{Repository name in format "owner/repo". Will guess the current
repo if not specified.}

\item{tag}{which release tag(s) do we want information for? If \code{NULL} (default),
will return a table for all available release tags.}

\item{.token}{GitHub authentication token, see \verb{[gh::gh_token()]}}
}
\value{
a data.frame of release asset names, release tag, timestamp, owner, and repo.
}
\description{
List all assets attached to a release
}
\examples{
\dontrun{
pb_list("cboettig/piggyback-tests")
}
}
\seealso{
\code{pb_releases} for a list of all releases in repository
}
