# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include servicequotas_service.R
NULL

#' Associates your quota request template with your organization
#'
#' @description
#' Associates your quota request template with your organization. When a new Amazon Web Services account is created in your organization, the quota increase requests in the template are automatically applied to the account. You can add a quota increase request for any adjustable quota to your template.
#'
#' See [https://www.paws-r-sdk.com/docs/servicequotas_associate_service_quota_template/](https://www.paws-r-sdk.com/docs/servicequotas_associate_service_quota_template/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname servicequotas_associate_service_quota_template
servicequotas_associate_service_quota_template <- function() {
  op <- new_operation(
    name = "AssociateServiceQuotaTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$associate_service_quota_template_input()
  output <- .servicequotas$associate_service_quota_template_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$associate_service_quota_template <- servicequotas_associate_service_quota_template

#' Deletes the quota increase request for the specified quota from your
#' quota request template
#'
#' @description
#' Deletes the quota increase request for the specified quota from your quota request template.
#'
#' See [https://www.paws-r-sdk.com/docs/servicequotas_delete_service_quota_increase_request_from_template/](https://www.paws-r-sdk.com/docs/servicequotas_delete_service_quota_increase_request_from_template/) for full documentation.
#'
#' @param ServiceCode &#91;required&#93; Specifies the service identifier. To find the service code value for an
#' Amazon Web Services service, use the
#' [`list_services`][servicequotas_list_services] operation.
#' @param QuotaCode &#91;required&#93; Specifies the quota identifier. To find the quota code for a specific
#' quota, use the
#' [`list_service_quotas`][servicequotas_list_service_quotas] operation,
#' and look for the `QuotaCode` response in the output for the quota you
#' want.
#' @param AwsRegion &#91;required&#93; Specifies the Amazon Web Services Region for which the request was made.
#'
#' @keywords internal
#'
#' @rdname servicequotas_delet_servi_quota_incre_reque_from_templ
servicequotas_delete_service_quota_increase_request_from_template <- function(ServiceCode, QuotaCode, AwsRegion) {
  op <- new_operation(
    name = "DeleteServiceQuotaIncreaseRequestFromTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$delete_service_quota_increase_request_from_template_input(ServiceCode = ServiceCode, QuotaCode = QuotaCode, AwsRegion = AwsRegion)
  output <- .servicequotas$delete_service_quota_increase_request_from_template_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$delete_service_quota_increase_request_from_template <- servicequotas_delete_service_quota_increase_request_from_template

#' Disables your quota request template
#'
#' @description
#' Disables your quota request template. After a template is disabled, the quota increase requests in the template are not applied to new Amazon Web Services accounts in your organization. Disabling a quota request template does not apply its quota increase requests.
#'
#' See [https://www.paws-r-sdk.com/docs/servicequotas_disassociate_service_quota_template/](https://www.paws-r-sdk.com/docs/servicequotas_disassociate_service_quota_template/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname servicequotas_disassociate_service_quota_template
servicequotas_disassociate_service_quota_template <- function() {
  op <- new_operation(
    name = "DisassociateServiceQuotaTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$disassociate_service_quota_template_input()
  output <- .servicequotas$disassociate_service_quota_template_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$disassociate_service_quota_template <- servicequotas_disassociate_service_quota_template

#' Retrieves the default value for the specified quota
#'
#' @description
#' Retrieves the default value for the specified quota. The default value does not reflect any quota increases.
#'
#' See [https://www.paws-r-sdk.com/docs/servicequotas_get_aws_default_service_quota/](https://www.paws-r-sdk.com/docs/servicequotas_get_aws_default_service_quota/) for full documentation.
#'
#' @param ServiceCode &#91;required&#93; Specifies the service identifier. To find the service code value for an
#' Amazon Web Services service, use the
#' [`list_services`][servicequotas_list_services] operation.
#' @param QuotaCode &#91;required&#93; Specifies the quota identifier. To find the quota code for a specific
#' quota, use the
#' [`list_service_quotas`][servicequotas_list_service_quotas] operation,
#' and look for the `QuotaCode` response in the output for the quota you
#' want.
#'
#' @keywords internal
#'
#' @rdname servicequotas_get_aws_default_service_quota
servicequotas_get_aws_default_service_quota <- function(ServiceCode, QuotaCode) {
  op <- new_operation(
    name = "GetAWSDefaultServiceQuota",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$get_aws_default_service_quota_input(ServiceCode = ServiceCode, QuotaCode = QuotaCode)
  output <- .servicequotas$get_aws_default_service_quota_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$get_aws_default_service_quota <- servicequotas_get_aws_default_service_quota

#' Retrieves the status of the association for the quota request template
#'
#' @description
#' Retrieves the status of the association for the quota request template.
#'
#' See [https://www.paws-r-sdk.com/docs/servicequotas_get_association_for_service_quota_template/](https://www.paws-r-sdk.com/docs/servicequotas_get_association_for_service_quota_template/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname servicequotas_get_association_for_service_quota_template
servicequotas_get_association_for_service_quota_template <- function() {
  op <- new_operation(
    name = "GetAssociationForServiceQuotaTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$get_association_for_service_quota_template_input()
  output <- .servicequotas$get_association_for_service_quota_template_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$get_association_for_service_quota_template <- servicequotas_get_association_for_service_quota_template

#' Retrieves information about the specified quota increase request
#'
#' @description
#' Retrieves information about the specified quota increase request.
#'
#' See [https://www.paws-r-sdk.com/docs/servicequotas_get_requested_service_quota_change/](https://www.paws-r-sdk.com/docs/servicequotas_get_requested_service_quota_change/) for full documentation.
#'
#' @param RequestId &#91;required&#93; Specifies the ID of the quota increase request.
#'
#' @keywords internal
#'
#' @rdname servicequotas_get_requested_service_quota_change
servicequotas_get_requested_service_quota_change <- function(RequestId) {
  op <- new_operation(
    name = "GetRequestedServiceQuotaChange",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$get_requested_service_quota_change_input(RequestId = RequestId)
  output <- .servicequotas$get_requested_service_quota_change_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$get_requested_service_quota_change <- servicequotas_get_requested_service_quota_change

#' Retrieves the applied quota value for the specified quota
#'
#' @description
#' Retrieves the applied quota value for the specified quota. For some quotas, only the default values are available. If the applied quota value is not available for a quota, the quota is not retrieved.
#'
#' See [https://www.paws-r-sdk.com/docs/servicequotas_get_service_quota/](https://www.paws-r-sdk.com/docs/servicequotas_get_service_quota/) for full documentation.
#'
#' @param ServiceCode &#91;required&#93; Specifies the service identifier. To find the service code value for an
#' Amazon Web Services service, use the
#' [`list_services`][servicequotas_list_services] operation.
#' @param QuotaCode &#91;required&#93; Specifies the quota identifier. To find the quota code for a specific
#' quota, use the
#' [`list_service_quotas`][servicequotas_list_service_quotas] operation,
#' and look for the `QuotaCode` response in the output for the quota you
#' want.
#' @param ContextId Specifies the Amazon Web Services account or resource to which the quota
#' applies. The value in this field depends on the context scope associated
#' with the specified service quota.
#'
#' @keywords internal
#'
#' @rdname servicequotas_get_service_quota
servicequotas_get_service_quota <- function(ServiceCode, QuotaCode, ContextId = NULL) {
  op <- new_operation(
    name = "GetServiceQuota",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$get_service_quota_input(ServiceCode = ServiceCode, QuotaCode = QuotaCode, ContextId = ContextId)
  output <- .servicequotas$get_service_quota_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$get_service_quota <- servicequotas_get_service_quota

#' Retrieves information about the specified quota increase request in your
#' quota request template
#'
#' @description
#' Retrieves information about the specified quota increase request in your quota request template.
#'
#' See [https://www.paws-r-sdk.com/docs/servicequotas_get_service_quota_increase_request_from_template/](https://www.paws-r-sdk.com/docs/servicequotas_get_service_quota_increase_request_from_template/) for full documentation.
#'
#' @param ServiceCode &#91;required&#93; Specifies the service identifier. To find the service code value for an
#' Amazon Web Services service, use the
#' [`list_services`][servicequotas_list_services] operation.
#' @param QuotaCode &#91;required&#93; Specifies the quota identifier. To find the quota code for a specific
#' quota, use the
#' [`list_service_quotas`][servicequotas_list_service_quotas] operation,
#' and look for the `QuotaCode` response in the output for the quota you
#' want.
#' @param AwsRegion &#91;required&#93; Specifies the Amazon Web Services Region for which you made the request.
#'
#' @keywords internal
#'
#' @rdname servicequotas_get_servi_quota_incre_reque_from_templ
servicequotas_get_service_quota_increase_request_from_template <- function(ServiceCode, QuotaCode, AwsRegion) {
  op <- new_operation(
    name = "GetServiceQuotaIncreaseRequestFromTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$get_service_quota_increase_request_from_template_input(ServiceCode = ServiceCode, QuotaCode = QuotaCode, AwsRegion = AwsRegion)
  output <- .servicequotas$get_service_quota_increase_request_from_template_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$get_service_quota_increase_request_from_template <- servicequotas_get_service_quota_increase_request_from_template

#' Lists the default values for the quotas for the specified Amazon Web
#' Service
#'
#' @description
#' Lists the default values for the quotas for the specified Amazon Web Service. A default value does not reflect any quota increases.
#'
#' See [https://www.paws-r-sdk.com/docs/servicequotas_list_aws_default_service_quotas/](https://www.paws-r-sdk.com/docs/servicequotas_list_aws_default_service_quotas/) for full documentation.
#'
#' @param ServiceCode &#91;required&#93; Specifies the service identifier. To find the service code value for an
#' Amazon Web Services service, use the
#' [`list_services`][servicequotas_list_services] operation.
#' @param NextToken Specifies a value for receiving additional results after you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#' @param MaxResults Specifies the maximum number of results that you want included on each
#' page of the response. If you do not include this parameter, it defaults
#' to a value appropriate to the operation. If additional items exist
#' beyond those included in the current response, the `NextToken` response
#' element is present and has a value (is not null). Include that value as
#' the `NextToken` request parameter in the next call to the operation to
#' get the next part of the results.
#' 
#' An API operation can return fewer results than the maximum even when
#' there are more results available. You should check `NextToken` after
#' every operation to ensure that you receive all of the results.
#'
#' @keywords internal
#'
#' @rdname servicequotas_list_aws_default_service_quotas
servicequotas_list_aws_default_service_quotas <- function(ServiceCode, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListAWSDefaultServiceQuotas",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Quotas")
  )
  input <- .servicequotas$list_aws_default_service_quotas_input(ServiceCode = ServiceCode, NextToken = NextToken, MaxResults = MaxResults)
  output <- .servicequotas$list_aws_default_service_quotas_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$list_aws_default_service_quotas <- servicequotas_list_aws_default_service_quotas

#' Retrieves the quota increase requests for the specified Amazon Web
#' Service
#'
#' @description
#' Retrieves the quota increase requests for the specified Amazon Web Service.
#'
#' See [https://www.paws-r-sdk.com/docs/servicequotas_list_requested_service_quota_change_history/](https://www.paws-r-sdk.com/docs/servicequotas_list_requested_service_quota_change_history/) for full documentation.
#'
#' @param ServiceCode Specifies the service identifier. To find the service code value for an
#' Amazon Web Services service, use the
#' [`list_services`][servicequotas_list_services] operation.
#' @param Status Specifies that you want to filter the results to only the requests with
#' the matching status.
#' @param NextToken Specifies a value for receiving additional results after you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#' @param MaxResults Specifies the maximum number of results that you want included on each
#' page of the response. If you do not include this parameter, it defaults
#' to a value appropriate to the operation. If additional items exist
#' beyond those included in the current response, the `NextToken` response
#' element is present and has a value (is not null). Include that value as
#' the `NextToken` request parameter in the next call to the operation to
#' get the next part of the results.
#' 
#' An API operation can return fewer results than the maximum even when
#' there are more results available. You should check `NextToken` after
#' every operation to ensure that you receive all of the results.
#' @param QuotaRequestedAtLevel Specifies at which level within the Amazon Web Services account the
#' quota request applies to.
#'
#' @keywords internal
#'
#' @rdname servicequotas_list_requested_service_quota_change_history
servicequotas_list_requested_service_quota_change_history <- function(ServiceCode = NULL, Status = NULL, NextToken = NULL, MaxResults = NULL, QuotaRequestedAtLevel = NULL) {
  op <- new_operation(
    name = "ListRequestedServiceQuotaChangeHistory",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "RequestedQuotas")
  )
  input <- .servicequotas$list_requested_service_quota_change_history_input(ServiceCode = ServiceCode, Status = Status, NextToken = NextToken, MaxResults = MaxResults, QuotaRequestedAtLevel = QuotaRequestedAtLevel)
  output <- .servicequotas$list_requested_service_quota_change_history_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$list_requested_service_quota_change_history <- servicequotas_list_requested_service_quota_change_history

#' Retrieves the quota increase requests for the specified quota
#'
#' @description
#' Retrieves the quota increase requests for the specified quota.
#'
#' See [https://www.paws-r-sdk.com/docs/servicequotas_list_requested_service_quota_change_history_by_quota/](https://www.paws-r-sdk.com/docs/servicequotas_list_requested_service_quota_change_history_by_quota/) for full documentation.
#'
#' @param ServiceCode &#91;required&#93; Specifies the service identifier. To find the service code value for an
#' Amazon Web Services service, use the
#' [`list_services`][servicequotas_list_services] operation.
#' @param QuotaCode &#91;required&#93; Specifies the quota identifier. To find the quota code for a specific
#' quota, use the
#' [`list_service_quotas`][servicequotas_list_service_quotas] operation,
#' and look for the `QuotaCode` response in the output for the quota you
#' want.
#' @param Status Specifies that you want to filter the results to only the requests with
#' the matching status.
#' @param NextToken Specifies a value for receiving additional results after you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#' @param MaxResults Specifies the maximum number of results that you want included on each
#' page of the response. If you do not include this parameter, it defaults
#' to a value appropriate to the operation. If additional items exist
#' beyond those included in the current response, the `NextToken` response
#' element is present and has a value (is not null). Include that value as
#' the `NextToken` request parameter in the next call to the operation to
#' get the next part of the results.
#' 
#' An API operation can return fewer results than the maximum even when
#' there are more results available. You should check `NextToken` after
#' every operation to ensure that you receive all of the results.
#' @param QuotaRequestedAtLevel Specifies at which level within the Amazon Web Services account the
#' quota request applies to.
#'
#' @keywords internal
#'
#' @rdname servicequotas_list_reque_servi_quota_chang_histo_by_quota
servicequotas_list_requested_service_quota_change_history_by_quota <- function(ServiceCode, QuotaCode, Status = NULL, NextToken = NULL, MaxResults = NULL, QuotaRequestedAtLevel = NULL) {
  op <- new_operation(
    name = "ListRequestedServiceQuotaChangeHistoryByQuota",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "RequestedQuotas")
  )
  input <- .servicequotas$list_requested_service_quota_change_history_by_quota_input(ServiceCode = ServiceCode, QuotaCode = QuotaCode, Status = Status, NextToken = NextToken, MaxResults = MaxResults, QuotaRequestedAtLevel = QuotaRequestedAtLevel)
  output <- .servicequotas$list_requested_service_quota_change_history_by_quota_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$list_requested_service_quota_change_history_by_quota <- servicequotas_list_requested_service_quota_change_history_by_quota

#' Lists the quota increase requests in the specified quota request
#' template
#'
#' @description
#' Lists the quota increase requests in the specified quota request template.
#'
#' See [https://www.paws-r-sdk.com/docs/servicequotas_list_service_quota_increase_requests_in_template/](https://www.paws-r-sdk.com/docs/servicequotas_list_service_quota_increase_requests_in_template/) for full documentation.
#'
#' @param ServiceCode Specifies the service identifier. To find the service code value for an
#' Amazon Web Services service, use the
#' [`list_services`][servicequotas_list_services] operation.
#' @param AwsRegion Specifies the Amazon Web Services Region for which you made the request.
#' @param NextToken Specifies a value for receiving additional results after you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#' @param MaxResults Specifies the maximum number of results that you want included on each
#' page of the response. If you do not include this parameter, it defaults
#' to a value appropriate to the operation. If additional items exist
#' beyond those included in the current response, the `NextToken` response
#' element is present and has a value (is not null). Include that value as
#' the `NextToken` request parameter in the next call to the operation to
#' get the next part of the results.
#' 
#' An API operation can return fewer results than the maximum even when
#' there are more results available. You should check `NextToken` after
#' every operation to ensure that you receive all of the results.
#'
#' @keywords internal
#'
#' @rdname servicequotas_list_servi_quota_incre_reque_in_templ
servicequotas_list_service_quota_increase_requests_in_template <- function(ServiceCode = NULL, AwsRegion = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListServiceQuotaIncreaseRequestsInTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "ServiceQuotaIncreaseRequestInTemplateList")
  )
  input <- .servicequotas$list_service_quota_increase_requests_in_template_input(ServiceCode = ServiceCode, AwsRegion = AwsRegion, NextToken = NextToken, MaxResults = MaxResults)
  output <- .servicequotas$list_service_quota_increase_requests_in_template_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$list_service_quota_increase_requests_in_template <- servicequotas_list_service_quota_increase_requests_in_template

#' Lists the applied quota values for the specified Amazon Web Service
#'
#' @description
#' Lists the applied quota values for the specified Amazon Web Service. For some quotas, only the default values are available. If the applied quota value is not available for a quota, the quota is not retrieved.
#'
#' See [https://www.paws-r-sdk.com/docs/servicequotas_list_service_quotas/](https://www.paws-r-sdk.com/docs/servicequotas_list_service_quotas/) for full documentation.
#'
#' @param ServiceCode &#91;required&#93; Specifies the service identifier. To find the service code value for an
#' Amazon Web Services service, use the
#' [`list_services`][servicequotas_list_services] operation.
#' @param NextToken Specifies a value for receiving additional results after you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#' @param MaxResults Specifies the maximum number of results that you want included on each
#' page of the response. If you do not include this parameter, it defaults
#' to a value appropriate to the operation. If additional items exist
#' beyond those included in the current response, the `NextToken` response
#' element is present and has a value (is not null). Include that value as
#' the `NextToken` request parameter in the next call to the operation to
#' get the next part of the results.
#' 
#' An API operation can return fewer results than the maximum even when
#' there are more results available. You should check `NextToken` after
#' every operation to ensure that you receive all of the results.
#' @param QuotaCode Specifies the quota identifier. To find the quota code for a specific
#' quota, use the
#' [`list_service_quotas`][servicequotas_list_service_quotas] operation,
#' and look for the `QuotaCode` response in the output for the quota you
#' want.
#' @param QuotaAppliedAtLevel Specifies at which level of granularity that the quota value is applied.
#'
#' @keywords internal
#'
#' @rdname servicequotas_list_service_quotas
servicequotas_list_service_quotas <- function(ServiceCode, NextToken = NULL, MaxResults = NULL, QuotaCode = NULL, QuotaAppliedAtLevel = NULL) {
  op <- new_operation(
    name = "ListServiceQuotas",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Quotas")
  )
  input <- .servicequotas$list_service_quotas_input(ServiceCode = ServiceCode, NextToken = NextToken, MaxResults = MaxResults, QuotaCode = QuotaCode, QuotaAppliedAtLevel = QuotaAppliedAtLevel)
  output <- .servicequotas$list_service_quotas_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$list_service_quotas <- servicequotas_list_service_quotas

#' Lists the names and codes for the Amazon Web Services integrated with
#' Service Quotas
#'
#' @description
#' Lists the names and codes for the Amazon Web Services integrated with Service Quotas.
#'
#' See [https://www.paws-r-sdk.com/docs/servicequotas_list_services/](https://www.paws-r-sdk.com/docs/servicequotas_list_services/) for full documentation.
#'
#' @param NextToken Specifies a value for receiving additional results after you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#' @param MaxResults Specifies the maximum number of results that you want included on each
#' page of the response. If you do not include this parameter, it defaults
#' to a value appropriate to the operation. If additional items exist
#' beyond those included in the current response, the `NextToken` response
#' element is present and has a value (is not null). Include that value as
#' the `NextToken` request parameter in the next call to the operation to
#' get the next part of the results.
#' 
#' An API operation can return fewer results than the maximum even when
#' there are more results available. You should check `NextToken` after
#' every operation to ensure that you receive all of the results.
#'
#' @keywords internal
#'
#' @rdname servicequotas_list_services
servicequotas_list_services <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListServices",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Services")
  )
  input <- .servicequotas$list_services_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .servicequotas$list_services_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$list_services <- servicequotas_list_services

#' Returns a list of the tags assigned to the specified applied quota
#'
#' @description
#' Returns a list of the tags assigned to the specified applied quota.
#'
#' See [https://www.paws-r-sdk.com/docs/servicequotas_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/servicequotas_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) for the applied quota for which you want
#' to list tags. You can get this information by using the Service Quotas
#' console, or by listing the quotas using the
#' [list-service-quotas](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html)
#' CLI command or the
#' [`list_service_quotas`][servicequotas_list_service_quotas] Amazon Web
#' Services API operation.
#'
#' @keywords internal
#'
#' @rdname servicequotas_list_tags_for_resource
servicequotas_list_tags_for_resource <- function(ResourceARN) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$list_tags_for_resource_input(ResourceARN = ResourceARN)
  output <- .servicequotas$list_tags_for_resource_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$list_tags_for_resource <- servicequotas_list_tags_for_resource

#' Adds a quota increase request to your quota request template
#'
#' @description
#' Adds a quota increase request to your quota request template.
#'
#' See [https://www.paws-r-sdk.com/docs/servicequotas_put_service_quota_increase_request_into_template/](https://www.paws-r-sdk.com/docs/servicequotas_put_service_quota_increase_request_into_template/) for full documentation.
#'
#' @param QuotaCode &#91;required&#93; Specifies the quota identifier. To find the quota code for a specific
#' quota, use the
#' [`list_service_quotas`][servicequotas_list_service_quotas] operation,
#' and look for the `QuotaCode` response in the output for the quota you
#' want.
#' @param ServiceCode &#91;required&#93; Specifies the service identifier. To find the service code value for an
#' Amazon Web Services service, use the
#' [`list_services`][servicequotas_list_services] operation.
#' @param AwsRegion &#91;required&#93; Specifies the Amazon Web Services Region to which the template applies.
#' @param DesiredValue &#91;required&#93; Specifies the new, increased value for the quota.
#'
#' @keywords internal
#'
#' @rdname servicequotas_put_servi_quota_incre_reque_into_templ
servicequotas_put_service_quota_increase_request_into_template <- function(QuotaCode, ServiceCode, AwsRegion, DesiredValue) {
  op <- new_operation(
    name = "PutServiceQuotaIncreaseRequestIntoTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$put_service_quota_increase_request_into_template_input(QuotaCode = QuotaCode, ServiceCode = ServiceCode, AwsRegion = AwsRegion, DesiredValue = DesiredValue)
  output <- .servicequotas$put_service_quota_increase_request_into_template_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$put_service_quota_increase_request_into_template <- servicequotas_put_service_quota_increase_request_into_template

#' Submits a quota increase request for the specified quota
#'
#' @description
#' Submits a quota increase request for the specified quota.
#'
#' See [https://www.paws-r-sdk.com/docs/servicequotas_request_service_quota_increase/](https://www.paws-r-sdk.com/docs/servicequotas_request_service_quota_increase/) for full documentation.
#'
#' @param ServiceCode &#91;required&#93; Specifies the service identifier. To find the service code value for an
#' Amazon Web Services service, use the
#' [`list_services`][servicequotas_list_services] operation.
#' @param QuotaCode &#91;required&#93; Specifies the quota identifier. To find the quota code for a specific
#' quota, use the
#' [`list_service_quotas`][servicequotas_list_service_quotas] operation,
#' and look for the `QuotaCode` response in the output for the quota you
#' want.
#' @param DesiredValue &#91;required&#93; Specifies the new, increased value for the quota.
#' @param ContextId Specifies the Amazon Web Services account or resource to which the quota
#' applies. The value in this field depends on the context scope associated
#' with the specified service quota.
#'
#' @keywords internal
#'
#' @rdname servicequotas_request_service_quota_increase
servicequotas_request_service_quota_increase <- function(ServiceCode, QuotaCode, DesiredValue, ContextId = NULL) {
  op <- new_operation(
    name = "RequestServiceQuotaIncrease",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$request_service_quota_increase_input(ServiceCode = ServiceCode, QuotaCode = QuotaCode, DesiredValue = DesiredValue, ContextId = ContextId)
  output <- .servicequotas$request_service_quota_increase_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$request_service_quota_increase <- servicequotas_request_service_quota_increase

#' Adds tags to the specified applied quota
#'
#' @description
#' Adds tags to the specified applied quota. You can include one or more tags to add to the quota.
#'
#' See [https://www.paws-r-sdk.com/docs/servicequotas_tag_resource/](https://www.paws-r-sdk.com/docs/servicequotas_tag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) for the applied quota. You can get this
#' information by using the Service Quotas console, or by listing the
#' quotas using the
#' [list-service-quotas](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html)
#' CLI command or the
#' [`list_service_quotas`][servicequotas_list_service_quotas] Amazon Web
#' Services API operation.
#' @param Tags &#91;required&#93; The tags that you want to add to the resource.
#'
#' @keywords internal
#'
#' @rdname servicequotas_tag_resource
servicequotas_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .servicequotas$tag_resource_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$tag_resource <- servicequotas_tag_resource

#' Removes tags from the specified applied quota
#'
#' @description
#' Removes tags from the specified applied quota. You can specify one or more tags to remove.
#'
#' See [https://www.paws-r-sdk.com/docs/servicequotas_untag_resource/](https://www.paws-r-sdk.com/docs/servicequotas_untag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) for the applied quota that you want to
#' untag. You can get this information by using the Service Quotas console,
#' or by listing the quotas using the
#' [list-service-quotas](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html)
#' CLI command or the
#' [`list_service_quotas`][servicequotas_list_service_quotas] Amazon Web
#' Services API operation.
#' @param TagKeys &#91;required&#93; The keys of the tags that you want to remove from the resource.
#'
#' @keywords internal
#'
#' @rdname servicequotas_untag_resource
servicequotas_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .servicequotas$untag_resource_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$untag_resource <- servicequotas_untag_resource
