% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applicationinsights_operations.R
\name{applicationinsights_list_problems}
\alias{applicationinsights_list_problems}
\title{Lists the problems with your application}
\usage{
applicationinsights_list_problems(ResourceGroupName, StartTime, EndTime,
  MaxResults, NextToken)
}
\arguments{
\item{ResourceGroupName}{The name of the resource group.}

\item{StartTime}{The time when the problem was detected, in epoch seconds. If you don't
specify a time frame for the request, problems within the past seven
days are returned.}

\item{EndTime}{The time when the problem ended, in epoch seconds. If not specified,
problems within the past seven days are returned.}

\item{MaxResults}{The maximum number of results to return in a single call. To retrieve
the remaining results, make another call with the returned \code{NextToken}
value.}

\item{NextToken}{The token to request the next page of results.}
}
\value{
A list with the following syntax:\preformatted{list(
  ProblemList = list(
    list(
      Id = "string",
      Title = "string",
      Insights = "string",
      Status = "IGNORE"|"RESOLVED"|"PENDING",
      AffectedResource = "string",
      StartTime = as.POSIXct(
        "2015-01-01"
      ),
      EndTime = as.POSIXct(
        "2015-01-01"
      ),
      SeverityLevel = "Low"|"Medium"|"High",
      ResourceGroupName = "string",
      Feedback = list(
        "NOT_SPECIFIED"|"USEFUL"|"NOT_USEFUL"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Lists the problems with your application.
}
\section{Request syntax}{
\preformatted{svc$list_problems(
  ResourceGroupName = "string",
  StartTime = as.POSIXct(
    "2015-01-01"
  ),
  EndTime = as.POSIXct(
    "2015-01-01"
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
