% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_update_maintenance_window_target}
\alias{ssm_update_maintenance_window_target}
\title{Modifies the target of an existing maintenance window}
\usage{
ssm_update_maintenance_window_target(WindowId, WindowTargetId, Targets,
  OwnerInformation, Name, Description, Replace)
}
\arguments{
\item{WindowId}{[required] The maintenance window ID with which to modify the target.}

\item{WindowTargetId}{[required] The target ID to modify.}

\item{Targets}{The targets to add or replace.}

\item{OwnerInformation}{User-provided value that will be included in any CloudWatch events
raised while running tasks for these targets in this maintenance window.}

\item{Name}{A name for the update.}

\item{Description}{An optional description for the update.}

\item{Replace}{If True, then all fields that are required by the
RegisterTargetWithMaintenanceWindow action are also required for this
API request. Optional fields that are not specified are set to null.}
}
\description{
Modifies the target of an existing maintenance window. You can change
the following:
\itemize{
\item Name
\item Description
\item Owner
\item IDs for an ID target
\item Tags for a Tag target
\item From any supported tag type to another. The three supported tag
types are ID target, Tag target, and resource group. For more
information, see Target.
}

If a parameter is null, then the corresponding field is not modified.
}
\section{Request syntax}{
\preformatted{svc$update_maintenance_window_target(
  WindowId = "string",
  WindowTargetId = "string",
  Targets = list(
    list(
      Key = "string",
      Values = list(
        "string"
      )
    )
  ),
  OwnerInformation = "string",
  Name = "string",
  Description = "string",
  Replace = TRUE|FALSE
)
}
}

\keyword{internal}
