% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_put_lifecycle_hook}
\alias{autoscaling_put_lifecycle_hook}
\title{Creates or updates a lifecycle hook for the specified Auto Scaling group}
\usage{
autoscaling_put_lifecycle_hook(LifecycleHookName, AutoScalingGroupName,
  LifecycleTransition, RoleARN, NotificationTargetARN,
  NotificationMetadata, HeartbeatTimeout, DefaultResult)
}
\arguments{
\item{LifecycleHookName}{[required] The name of the lifecycle hook.}

\item{AutoScalingGroupName}{[required] The name of the Auto Scaling group.}

\item{LifecycleTransition}{The instance state to which you want to attach the lifecycle hook. The
valid values are:
\itemize{
\item autoscaling:EC2\\_INSTANCE\\_LAUNCHING
\item autoscaling:EC2\\_INSTANCE\\_TERMINATING
}

Required for new lifecycle hooks, but optional when updating existing
hooks.}

\item{RoleARN}{The ARN of the IAM role that allows the Auto Scaling group to publish to
the specified notification target, for example, an Amazon SNS topic or
an Amazon SQS queue.

Required for new lifecycle hooks, but optional when updating existing
hooks.}

\item{NotificationTargetARN}{The ARN of the notification target that Amazon EC2 Auto Scaling uses to
notify you when an instance is in the transition state for the lifecycle
hook. This target can be either an SQS queue or an SNS topic.

If you specify an empty string, this overrides the current ARN.

This operation uses the JSON format when sending notifications to an
Amazon SQS queue, and an email key-value pair format when sending
notifications to an Amazon SNS topic.

When you specify a notification target, Amazon EC2 Auto Scaling sends it
a test message. Test messages contain the following additional key-value
pair: \code{"Event": "autoscaling:TEST_NOTIFICATION"}.}

\item{NotificationMetadata}{Additional information that you want to include any time Amazon EC2 Auto
Scaling sends a message to the notification target.}

\item{HeartbeatTimeout}{The maximum time, in seconds, that can elapse before the lifecycle hook
times out. The range is from \code{30} to \code{7200} seconds. The default value
is \code{3600} seconds (1 hour).

If the lifecycle hook times out, Amazon EC2 Auto Scaling performs the
action that you specified in the \code{DefaultResult} parameter. You can
prevent the lifecycle hook from timing out by calling the
RecordLifecycleActionHeartbeat API.}

\item{DefaultResult}{Defines the action the Auto Scaling group should take when the lifecycle
hook timeout elapses or if an unexpected failure occurs. This parameter
can be either \code{CONTINUE} or \code{ABANDON}. The default value is \code{ABANDON}.}
}
\description{
Creates or updates a lifecycle hook for the specified Auto Scaling
group.

A lifecycle hook tells Amazon EC2 Auto Scaling to perform an action on
an instance when the instance launches (before it is put into service)
or as the instance terminates (before it is fully terminated).

This step is a part of the procedure for adding a lifecycle hook to an
Auto Scaling group:
\enumerate{
\item (Optional) Create a Lambda function and a rule that allows
CloudWatch Events to invoke your Lambda function when Amazon EC2
Auto Scaling launches or terminates instances.
\item (Optional) Create a notification target and an IAM role. The target
can be either an Amazon SQS queue or an Amazon SNS topic. The role
allows Amazon EC2 Auto Scaling to publish lifecycle notifications to
the target.
\item \strong{Create the lifecycle hook. Specify whether the hook is used when
the instances launch or terminate.}
\item If you need more time, record the lifecycle action heartbeat to keep
the instance in a pending state using the
RecordLifecycleActionHeartbeat API call.
\item If you finish before the timeout period ends, complete the lifecycle
action using the CompleteLifecycleAction API call.
}

For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html}{Amazon EC2 Auto Scaling lifecycle hooks}
in the \emph{Amazon EC2 Auto Scaling User Guide}.

If you exceed your maximum limit of lifecycle hooks, which by default is
50 per Auto Scaling group, the call fails.

You can view the lifecycle hooks for an Auto Scaling group using the
DescribeLifecycleHooks API call. If you are no longer using a lifecycle
hook, you can delete it by calling the DeleteLifecycleHook API.
}
\section{Request syntax}{
\preformatted{svc$put_lifecycle_hook(
  LifecycleHookName = "string",
  AutoScalingGroupName = "string",
  LifecycleTransition = "string",
  RoleARN = "string",
  NotificationTargetARN = "string",
  NotificationMetadata = "string",
  HeartbeatTimeout = 123,
  DefaultResult = "string"
)
}
}

\examples{
\dontrun{
# This example creates a lifecycle hook.
svc$put_lifecycle_hook(
  AutoScalingGroupName = "my-auto-scaling-group",
  LifecycleHookName = "my-lifecycle-hook",
  LifecycleTransition = "autoscaling:EC2_INSTANCE_LAUNCHING",
  NotificationTargetARN = "arn:aws:sns:us-west-2:123456789012:my-sns-topic --role-arn",
  RoleARN = "arn:aws:iam::123456789012:role/my-auto-scaling-role"
)
}

}
\keyword{internal}
