% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_delete_tags}
\alias{autoscaling_delete_tags}
\title{Deletes the specified tags}
\usage{
autoscaling_delete_tags(Tags)
}
\arguments{
\item{Tags}{[required] One or more tags.}
}
\description{
Deletes the specified tags.
}
\section{Request syntax}{
\preformatted{svc$delete_tags(
  Tags = list(
    list(
      ResourceId = "string",
      ResourceType = "string",
      Key = "string",
      Value = "string",
      PropagateAtLaunch = TRUE|FALSE
    )
  )
)
}
}

\examples{
\dontrun{
# This example deletes the specified tag from the specified Auto Scaling
# group.
svc$delete_tags(
  Tags = list(
    list(
      Key = "Dept",
      ResourceId = "my-auto-scaling-group",
      ResourceType = "auto-scaling-group",
      Value = "Research"
    )
  )
)
}

}
\keyword{internal}
