% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imagebar.R
\name{imagebar}
\alias{imagebar}
\title{Plot a bar chart with bars filled with png and jpeg images.}
\usage{
imagebar(data, x, y, group = NULL, xlab = "", ylab = "",
  label.size = 3.5, vjust = -1, pattern.type, frame.color = "black",
  frame.size = 1, legend.type = "h", legend.h = 6, legend.y.pos = 0.5,
  legend.pixel = 5)
}
\arguments{
\item{data}{the data to be used.}

\item{x}{the variable used on x axis.}

\item{y}{the variable used on y axis.}

\item{group}{the variable used as the second grouping variable on x axis.}

\item{xlab}{a character string to give x axis label.}

\item{ylab}{a character string to give y axis label.}

\item{label.size}{the font size of labels shown above the bars.}

\item{vjust}{the distance of labels from the top border of each bar.}

\item{pattern.type}{a list of objects returned by \code{readPNG} and \code{readJPEG} used to fill the bars.}

\item{frame.color}{the color of the borders of bars.}

\item{frame.size}{a numeric value, the line size for the borders of bars.}

\item{legend.type}{if legend.type='h', the layout of legends is horizontal;
if legend.type='v', the layout of legends is vertical.}

\item{legend.h}{a numeric value to change the height of legend boxes.}

\item{legend.y.pos}{a numeric value to change the position of legends on y axis.}

\item{legend.pixel}{a numeric value to change the pixel of legends.}
}
\value{
A ggplot object.
}
\description{
The \code{imagebar} function is a tool for creating versatile bar charts by filling the bars with external png and jpeg images.
}
\details{
\code{imagebar} function offers flexible ways in doing bar charts.
}
\examples{
library(patternplot)
library(jpeg)

#http://all-free-download.com/free-vector/modern-seamless-pattern.html
childcare<-readJPEG(system.file("img", "childcare.jpg", package="patternplot"))
food<-readJPEG(system.file("img", "food.jpg", package="patternplot"))
housing <-readJPEG(system.file("img", "housing.jpg", package="patternplot"))

#Example 1
data <- read.csv(system.file("extdata", "monthlyexp.csv", package="patternplot"))
data<-data[which(data$Location=='City 1'),]
x<-factor(data$Type, c('Housing', 'Food',  'Childcare'))
y<-data$Amount
pattern.type<-list(housing, food, childcare)
imagebar(data,x, y,group=NULL,pattern.type=pattern.type,
         frame.color=c('darkred', 'darkgreen', 'orange'),
         ylab='Monthly Expenses, Dollars')

}
\seealso{
Function \code{patternbar}
}
\author{
Chunqiao Luo (chunqiaoluo@gmail.com)
}
