% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pastNNsInfo.R
\name{pastNNsInfo}
\alias{pastNNsInfo}
\title{Finding Nearest Neighbors and Keeping their Topological Information}
\usage{
pastNNsInfo(CCSPAN, NNSPAN, Mx, Dx, SMx, PSMx, i, h)
}
\arguments{
\item{CCSPAN}{Integer, the span of common coordinates to exclude from the nearest neighbor search.}

\item{NNSPAN}{Integer, the number of nearest neighbors to consider for the analysis.}

\item{Mx}{Matrix, the main matrix representing the state space of the system.}

\item{Dx}{Numeric matrix, containing distances between points in the state space.}

\item{SMx}{Matrix, containing signatures of the state space.}

\item{PSMx}{Matrix, containing patterns derived from the signatures.}

\item{i}{Integer, the current index in time series data for which nearest neighbors are being considered.}

\item{h}{Integer, the horizon beyond which data is not considered in the nearest neighbor search.}
}
\value{
A list containing:
\itemize{
\item \code{i}: The current index in time series data.
\item \code{times}: The times of the nearest neighbors.
\item \code{dists}: The distances to the nearest neighbors.
\item \code{signatures}: The signatures of the nearest neighbors.
\item \code{patterns}: The patterns of the nearest neighbors.
\item \code{coordinates}: The coordinates of the nearest neighbors.
}
}
\description{
This function identifies the nearest neighbors of a given point in a time series, excluding common coordinate vectors and a specified horizon from the candidate nearest neighbors. It returns detailed information about these neighbors, including their times, distances, signatures, patterns, and coordinates.
}
\examples{
# Generate random data for demonstration
set.seed(123)
E <- 3
tau <- 1
Mx <- matrix(rnorm(300), nrow = 100)
Dx <- distanceMatrix(Mx, "minkowski")
SMx <- signatureSpace(Mx, E)
PSMx <- patternSpace(SMx, E)
CCSPAN <- (E - 1) * tau
NNSPAN <- E + 1
i <- 15
h <- 2
neighborsInfo <- pastNNsInfo(CCSPAN, NNSPAN, Mx, Dx, SMx, PSMx, i, h)
print(neighborsInfo)
}
