% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translate.R
\name{translate}
\alias{translate}
\alias{translate.default}
\title{Resolve a Model Specification for a Computational Engine}
\usage{
translate(x, ...)

\method{translate}{default}(x, engine = x$engine, ...)
}
\arguments{
\item{x}{A model specification.}

\item{...}{Not currently used.}

\item{engine}{The computational engine for the model (see \code{?set_engine}).}
}
\description{
\code{translate()} will translate a model specification into a code
object that is specific to a particular engine (e.g. R package).
It translates generic parameters to their counterparts.
}
\details{
\code{translate()} produces a \emph{template} call that lacks the specific
argument values (such as \code{data}, etc). These are filled in once
\code{fit()} is called with the specifics of the data for the model.
The call may also include \code{tune()} arguments if these are in
the specification. To handle the \code{tune()} arguments, you need to use the
\href{https://tune.tidymodels.org/}{tune package}. For more information
see \url{https://www.tidymodels.org/start/tuning/}

It does contain the resolved argument names that are specific to
the model fitting function/engine.

This function can be useful when you need to understand how
\code{parsnip} goes from a generic model specific to a model fitting
function.

\strong{Note}: this function is used internally and users should only use it
to understand what the underlying syntax would be. It should not be used
to modify the model specification.
}
\examples{
lm_spec <- linear_reg(penalty = 0.01)

# `penalty` is tranlsated to `lambda`
translate(lm_spec, engine = "glmnet")

# `penalty` not applicable for this model.
translate(lm_spec, engine = "lm")

# `penalty` is tranlsated to `reg_param`
translate(lm_spec, engine = "spark")

# with a placeholder for an unknown argument value:
translate(linear_reg(penalty = tune(), mixture = tune()), engine = "glmnet")

}
