% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlp.R
\name{mlp}
\alias{mlp}
\alias{update.mlp}
\title{General Interface for Single Layer Neural Network}
\usage{
mlp(mode = "unknown", hidden_units = NULL, penalty = NULL,
  dropout = NULL, epochs = NULL, activation = NULL)

\method{update}{mlp}(object, hidden_units = NULL, penalty = NULL,
  dropout = NULL, epochs = NULL, activation = NULL, fresh = FALSE,
  ...)
}
\arguments{
\item{mode}{A single character string for the type of model.
Possible values for this model are "unknown", "regression", or
"classification".}

\item{hidden_units}{An integer for the number of units in the hidden model.}

\item{penalty}{A non-negative numeric value for the amount of weight
decay.}

\item{dropout}{A number between 0 (inclusive) and 1 denoting the proportion
of model parameters randomly set to zero during model training.}

\item{epochs}{An integer for the number of training iterations.}

\item{activation}{A single character strong denoting the type of relationship
between the original predictors and the hidden unit layer. The activation
function between the hidden and output layers is automatically set to either
"linear" or "softmax" depending on the type of outcome. Possible values are:
"linear", "softmax", "relu", and "elu"}

\item{object}{A random forest model specification.}

\item{fresh}{A logical for whether the arguments should be
modified in-place of or replaced wholesale.}

\item{...}{Not used for \code{update}.}
}
\description{
\code{mlp}, for multilayer perceptron, is a way to generate a \emph{specification} of
a model before fitting and allows the model to be created using
different packages in R or via keras The main arguments for the
model are:
\itemize{
\item \code{hidden_units}: The number of units in the hidden layer
(default: 5).
\item \code{penalty}: The amount of L2 regularization (aka weight
decay, default is zero).
\item \code{dropout}: The proportion of parameters randomly dropped out of
the model (\code{keras} only, default is zero).
\item \code{epochs}: The number of training iterations (default: 20).
\item \code{activation}: The type of function that connects the hidden
layer and the input variables  (\code{keras} only, default is softmax).
}

If parameters need to be modified, this function can be used
in lieu of recreating the object from scratch.
}
\details{
These arguments are converted to their specific names at the
time that the model is fit. Other options and argument can be
set using \code{set_engine}. If left to their defaults
here (see above), the values are taken from the underlying model
functions. One exception is \code{hidden_units} when \code{nnet::nnet} is used; that
function's \code{size} argument has no default so a value of 5 units will be
used. Also, unless otherwise specified, the \code{linout} argument to
\code{nnet::nnet} will be set to \code{TRUE} when a regression model is created.
If parameters need to be modified, \code{update} can be used
in lieu of recreating the object from scratch.

The model can be created using the \code{fit()} function using the
following \emph{engines}:
\itemize{
\item \pkg{R}:  \code{"nnet"}
\item \pkg{keras}: \code{"keras"}
}

An error is thrown if both \code{penalty} and \code{dropout} are specified for
\code{keras} models.
}
\section{Engine Details}{


Engines may have pre-set default arguments when executing the
model fit call. For this type of
model, the template of the fit calls are:

\pkg{keras} classification

\Sexpr[results=rd]{parsnip:::show_fit(parsnip:::mlp(mode = "classification"), "keras")}

\pkg{keras} regression

\Sexpr[results=rd]{parsnip:::show_fit(parsnip:::mlp(mode = "regression"), "keras")}

\pkg{nnet} classification

\Sexpr[results=rd]{parsnip:::show_fit(parsnip:::mlp(mode = "classification"), "nnet")}

\pkg{nnet} regression

\Sexpr[results=rd]{parsnip:::show_fit(parsnip:::mlp(mode = "regression"), "nnet")}
}

\examples{
mlp(mode = "classification", penalty = 0.01)
# Parameters can be represented by a placeholder:
mlp(mode = "regression", hidden_units = varying())
model <- mlp(hidden_units = 10, dropout = 0.30)
model
update(model, hidden_units = 2)
update(model, hidden_units = 2, fresh = TRUE)
}
\seealso{
\code{\link[=varying]{varying()}}, \code{\link[=fit]{fit()}}
}
