% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apa_print_glm.R
\name{apa_print.lm}
\alias{apa_print.lm}
\alias{apa_print.glm}
\alias{apa_print.summary.glm}
\alias{apa_print.summary.lm}
\title{Typeset Statistical Results from GLM}
\usage{
\method{apa_print}{lm}(
  x,
  est_name = NULL,
  standardized = FALSE,
  conf.int = 0.95,
  observed = TRUE,
  in_paren = FALSE,
  ...
)

\method{apa_print}{glm}(
  x,
  est_name = NULL,
  standardized = FALSE,
  conf.int = 0.95,
  observed = TRUE,
  in_paren = FALSE,
  ...
)

\method{apa_print}{summary.glm}(x, ...)

\method{apa_print}{summary.lm}(x, ...)
}
\arguments{
\item{x}{\code{glm} or \code{lm} object.}

\item{est_name}{Character. If \code{NULL} (the default) the name given in \code{x}
(or a formally correct adaptation, such as "\eqn{b^*}" instead of "b" for
standardized regression coefficients) is used. Otherwise the supplied name
is used. See details.}

\item{standardized}{Logical. Indicates if coefficients were standardized
(e.g., using \code{scale()}), and leading zeros should be omitted if
appropriate. See details.}

\item{conf.int}{Numeric. Either a single value (range [0, 1]) giving the
confidence level or a two-column \code{matrix} with confidence region bounds as
column names (e.g. \code{"2.5 \%"} and \code{"97.5 \%"}) and coefficient names as row
names (in the same order as they appear in \code{summary(x)$coefficients}.
See details.}

\item{observed}{Logical. Indicates whether predictor variables were
observed. See details.}

\item{in_paren}{Logical. Whether the formatted string is to be reported in
parentheses. If \code{TRUE}, parentheses in the formatted string (e.g., those
enclosing degrees of freedom) are replaced with brackets.}

\item{...}{
  Arguments passed on to \code{\link[=apa_num]{apa_num}}
  \describe{
    \item{\code{}}{}
  }}
}
\description{
These methods take (generalized) linear model objects to create formatted
character strings to report the results in accordance with APA manuscript
guidelines.
}
\details{
The coefficient names are sanitized to facilitate their use as list names.
Parentheses are omitted and other non-word characters are replaced by \verb{_}
(see \code{\link[=sanitize_terms]{sanitize_terms()}}).

\code{est_name} is placed in the output string and is then passed to pandoc or
LaTeX through \pkg{knitr}. Thus, to the extent it is supported by the
final document type, you can pass LaTeX-markup to format the final text
(e.g., \code{"\\\\\\\\beta"} yields \eqn{\beta}).

If \code{standardized = TRUE}, \code{scale()} is removed from coefficient names
(see examples). This option is currently ignored for \code{glm}-objects.

If \code{conf.int} is a single value, confidence intervals are calculated using
\code{\link[stats:confint]{stats::confint()}}.

If \code{x} is an \code{lm} object and the \pkg{MBESS} package is available,
confidence intervals for \eqn{R^2} are computed using \code{\link[MBESS:ci.R2]{MBESS::ci.R2()}} to
obtain a confidence region that corresponds to the \eqn{\alpha}-level
chosen for the confidence intervals of regression coefficients (e.g.,
95\% CI or \eqn{\alpha = 0.05} for regression coefficients yields a 90\% CI
for \eqn{R^2}, see Steiger, 2004). If \code{observed = FALSE}, it is assumed
that predictors are fixed variables, i.e., "the values of the
[predictors] were selected a priori as part of the research design"
(p. 15, Kelly, 2007); put differently, it is assumed that predictors are
not random.
}
\examples{
# Data from Dobson (1990), p. 9.
ctl <- c(4.17, 5.58, 5.18, 6.11, 4.50, 4.61, 5.17, 4.53, 5.33, 5.14)
trt <- c(4.81, 4.17, 4.41, 3.59, 5.87, 3.83, 6.03, 4.89, 4.32, 4.69)
group <- gl(2, 10, 20, labels = c("Ctl", "Trt"))
weight <- c(ctl, trt)
lm_fit <- lm(weight ~ group)

apa_print(lm_fit)

trt <- rep(trt, 2) # More data is always better
ctl <- rep(ctl, 2)
lm_fit2 <- lm(scale(trt) ~ scale(ctl))

apa_print(lm_fit2, standardized = TRUE)

# It is possible to simplify the regression table with transmute_df_into_label():
transmute_df_into_label(apa_print(lm_fit2, standardized = TRUE))


# Dobson (1990) Page 93: Randomized Controlled Trial :
counts <- c(18,17,15,20,10,20,25,13,12)
outcome <- gl(3,1,9)
treatment <- gl(3,3)
d.AD <- data.frame(treatment, outcome, counts)
glm.D93 <- glm(counts ~ outcome + treatment, family = poisson())

apa_print(glm.D93)
}
\references{
Steiger (2004). Beyond the F Test: Effect Size Confidence Intervals and Tests of Close Fit in the Analysis of
Variance and Contrast Analysis. \emph{Psychological Methods}, \emph{9}(2), 164-182.
doi: \doi{10.1037/1082-989X.9.2.164}

Kelley, K. (2007). Confidence intervals for standardized effect sizes: Theory, application, and
implementation. \emph{Journal of Statistical Software}, \emph{20}(8), 1-24.
doi: \doi{10.18637/jss.v020.i08}
}
\seealso{
\code{\link[stats:confint]{stats::confint()}}, \code{\link[MBESS:ci.pvaf]{MBESS::ci.pvaf()}}

Other apa_print: 
\code{\link{apa_print.BFBayesFactor}()},
\code{\link{apa_print.aov}()},
\code{\link{apa_print.emmGrid}()},
\code{\link{apa_print.glht}()},
\code{\link{apa_print.htest}()},
\code{\link{apa_print.list}()},
\code{\link{apa_print.lme}()},
\code{\link{apa_print.merMod}()},
\code{\link{apa_print}()}
}
\concept{apa_print}
\value{
\code{apa_print()}-methods return a named list of class \code{apa_results} containing the following elements:

\item{estimate}{One or more character strings giving point estimates, confidence intervals, and confidence level. A single string is returned in a vector; multiple strings are returned as a named list. If no estimate is available the element is \code{NULL}.}
\item{statistic}{One or more character strings giving the test statistic, parameters (e.g., degrees of freedom), and p-value. A single string is returned in a vector; multiple strings are returned as a named list. If no estimate is available the element is \code{NULL}.}
\item{full_result}{One or more character strings comprised `estimate` and `statistic`. A single string is returned in a vector; multiple strings are returned as a named list. }
\item{table}{A \code{data.frame} of class \code{apa_results_table} that contains all elements of \code{estimate} and \code{statistics}. This table can be passed to \code{apa_table()} for reporting.}

Column names in \code{apa_results_table} are standardized following the \href{https://www.tidymodels.org/learn/develop/broom/#glossary}{\pkg{broom} glossary} (e.g., \code{term}, \code{estimate} \code{conf.int}, \code{statistic}, \code{df}, \code{df.residual}, \code{p.value}). Additionally, each column is labelled (e.g., \code{$\\hat{\\eta}^2_G$} or \code{$t$}) using the \pkg{tinylabels} package and these labels are used as column names when an \code{apa_results_table} is passed to \code{apa_table()}.

}
