% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbdb_queries.R
\name{pbdb_strata_auto}
\alias{pbdb_strata_auto}
\title{Get a list of strata matching a given prefix or partial name}
\usage{
pbdb_strata_auto(...)
}
\arguments{
\item{...}{Arguments passed to the API. See documentation for
accepted parameters at
\url{https://paleobiodb.org/data1.2/strata/auto}. E.g.:
\itemize{
\item \code{name}: A full or partial name. It must have at least 3
significant characters, and may end in a space followed by either
'g' or 'f' to indicate that you are looking for a group or
formation.
\item \code{rank}: Return only strata of the specified rank: \code{"formation"}
or \code{"group"}. This may be overridden by a suffix on the value of
\code{name}.
\item \code{lngmin}: Numeric. The longitude boundaries will be normalized to
fall between -180 and 180. Note that if you specify \code{lngmin} then
you must also specify \code{lngmax}. Returns only records whose
geographic location falls within the given bounding box (defined
by \code{lngmin}, \code{lngmax}, \code{latmin}, \code{latmax}). It generates two
adjacent bounding boxes if the range crosses the antimeridian.
\item \code{lngmax}: Numeric. The longitude boundaries will be normalized to
fall between -180 and 180.
\item \code{latmin}: Numeric between -90 and 90. Note that if you specify
\code{latmin} then you must also specify \code{latmax}.
\item \code{latmax}: Numeric between -90 and 90.
\item \code{vocab}: Set to \code{"pbdb"} to show the complete name of the
variables (by default variables have short 3-letter names).
}}
}
\value{
A data frame with information from the strata that match
the \code{name} parameter.
}
\description{
Returns a list of strata matching the given prefix or partial name.
This can be used to implement auto-completion for strata names, and
can be limited by geographic location if desired.
}
\examples{
\dontrun{
  pbdb_strata_auto(name = "Pin", vocab = "pbdb")
}
}
