\encoding{UTF-8}
\name{p3state.msm-package}
\alias{p3state.msm-package}
\alias{p3state.msm}
\docType{package}
\title{Analyzing survival data from an illness-death model}

\description{
\pkg{p3state.msm} provides functions for estimating semi-parametric regression
models but also to implement nonparametric estimators for the transition
probabilities. The methods can also be used in progressive three-state models.
In progressive three-state models, estimators for other quantities such as the
bivariate distribution function (for the sequentially ordered events) are also
given.
}

\details{
  \tabular{ll}{
    Package: \tab p3state.msm\cr
    Type: \tab Package\cr
    Version: \tab 1.3.2\cr
    Date: \tab 2023-01-19\cr
    License: \tab GPL-3\cr
    LazyLoad: \tab yes\cr
		LazyData: \tab yes\cr
  }
}

\author{
Luis Meira-Machado, Javier Roca Pardinas \email{roca@uvigo.es}\cr
and Artur Araújo \email{artur.stat@gmail.com}\cr
Maintainer: Luis Meira-Machado \email{lmachado@math.uminho.pt}
}

\references{
Crowley J., Hu M. (1977). Covariance analysis of heart transplant survival data. 
\emph{Journal of the American Statistical Association}, \bold{72}(357), 27-36. 
\doi{10.2307/2286902}

Meira-Machado L., De Una-Alvarez J., Cadarso-Suarez C. (2006). 
Nonparametric estimation of transition probabilities in a non-Markov illness-death model. 
\emph{Lifetime Data Analysis}, \bold{12}(3), 325-344. \doi{10.1007/s10985-006-9009-x}

de Una-Alvarez J., Meira-Machado L. (2008). 
A simple estimator of the bivariate distribution function for censored gap times. 
\emph{Statistics & Probability Letters}, \bold{78}(15), 2440-2445. \doi{10.1016/j.spl.2008.02.031}

Meira-Machado L., Roca-Pardinas J. (2011). 
p3state.msm: Analyzing Survival Data from an Illness-Death Model. 
\emph{Journal of Statistical Software}, \bold{38}(3), 1-18. \doi{10.18637/jss.v038.i03}
}

\keyword{package}
