% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/args.R
\name{dirpath_get}
\alias{dirpath_get}
\title{Convert file path to directory path}
\usage{
dirpath_get(flpth)
}
\arguments{
\item{flpth}{File path for which directory path will be returned.}
}
\value{
Character
}
\description{
Takes a file path and converts it to its directory path by
dropping the file name and extension. If \code{flpth} is already a directory
path, the argument will be returned unchanged. If nothing is provided,
nothing is returned (i.e. \code{character(0)}).
}
\examples{
library(outsider.base)
# get the parent directory from a filepath
drpth <- tempdir()
flpth <- file.path(drpth, 'testfile')
file.create(flpth)
(dirpath_get(flpth = flpth) == drpth)
(dirpath_get(flpth = drpth) == drpth)
file.remove(flpth)
}
