#ifndef PRIMAL_INFEASIBILITY_DATA_H
#define PRIMAL_INFEASIBILITY_DATA_H
#include "osqp.h"


/* create additional data and solutions structure */
typedef struct {
c_int status_test;
} primal_infeasibility_sols_data;

/* function prototypes */
OSQPData * generate_problem_primal_infeasibility();
void clean_problem_primal_infeasibility(OSQPData * data);
primal_infeasibility_sols_data *  generate_problem_primal_infeasibility_sols_data();
void clean_problem_primal_infeasibility_sols_data(primal_infeasibility_sols_data * data);


/* function to generate QP problem data */
OSQPData * generate_problem_primal_infeasibility(){

OSQPData * data = (OSQPData *)c_malloc(sizeof(OSQPData));

// Problem dimensions
data->n = 50;
data->m = 150;

// Problem vectors
data->l = (c_float*) c_malloc(150 * sizeof(c_float));
data->l[0] = -3.56949281639430360258;
data->l[1] = -1.13794958695631187595;
data->l[2] = -1.60750406617647012553;
data->l[3] = -3.42396747674446944032;
data->l[4] = -2.42755958631717216889;
data->l[5] = -3.55757661174058581466;
data->l[6] = -3.29399778410562715791;
data->l[7] = -3.16883326566181233730;
data->l[8] = -5.01822882448205831452;
data->l[9] = -2.20552921559617898239;
data->l[10] = -2.72964748190398598382;
data->l[11] = -2.58288001266629674291;
data->l[12] = -1.93870878954467418254;
data->l[13] = -3.03939958569135182387;
data->l[14] = -3.40793122217203681146;
data->l[15] = -1.72399040082214760616;
data->l[16] = -3.71978224316344530109;
data->l[17] = -3.33481671260544398905;
data->l[18] = -3.40872399733694875223;
data->l[19] = -5.44167429604380537000;
data->l[20] = -2.89489746659179969512;
data->l[21] = 0.21052254640023049248;
data->l[22] = -4.51930609824552753651;
data->l[23] = -1.72591508227261369868;
data->l[24] = -3.05961632244860437524;
data->l[25] = 4.25686364247777859759;
data->l[26] = -2.79976140110056759269;
data->l[27] = -3.28463941961106575818;
data->l[28] = -2.54663563673300785695;
data->l[29] = -0.67466758429296369570;
data->l[30] = -3.04366964159774644472;
data->l[31] = -2.38611627310615403985;
data->l[32] = -2.16070628197416203520;
data->l[33] = -2.46891280451172079324;
data->l[34] = -2.21438984650946757426;
data->l[35] = -3.74888819045797516694;
data->l[36] = -4.20997566225492469982;
data->l[37] = -3.79796509204259269410;
data->l[38] = -3.78510856082218438701;
data->l[39] = -3.01596545674937877024;
data->l[40] = -2.63456624026096131175;
data->l[41] = -2.05959882808388661246;
data->l[42] = -2.98264903821256943672;
data->l[43] = -3.05917760897857560209;
data->l[44] = -3.66604200632148158334;
data->l[45] = -4.30835265486860130579;
data->l[46] = -1.18164012510946303536;
data->l[47] = -2.73198204297136149066;
data->l[48] = -3.72667962088174231639;
data->l[49] = -1.16620015048067271479;
data->l[50] = -2.15463521542891900395;
data->l[51] = -2.51779013043637345248;
data->l[52] = -3.07580261618952599534;
data->l[53] = -2.67346691629268295998;
data->l[54] = -1.37976307769161188332;
data->l[55] = -2.97732139086276603734;
data->l[56] = -4.71738089260003157221;
data->l[57] = -3.32939743850793012925;
data->l[58] = -1.21122149447897875518;
data->l[59] = -4.30790210914210991433;
data->l[60] = -3.77434804540545121299;
data->l[61] = -1.51113334460026105255;
data->l[62] = -2.73720791275181962732;
data->l[63] = -3.45908682300260750253;
data->l[64] = -4.13019093431834338759;
data->l[65] = -4.54246616819751469762;
data->l[66] = -2.18933120433506855917;
data->l[67] = -2.56378002056808051989;
data->l[68] = -1.88789085103881881800;
data->l[69] = -2.06558862684574329194;
data->l[70] = -1.81204229523550153225;
data->l[71] = -2.68094563315194722719;
data->l[72] = -4.18971683936253214142;
data->l[73] = -2.25244014259800051647;
data->l[74] = -3.82150715997254009082;
data->l[75] = -2.90751723554293528551;
data->l[76] = -2.15637672974920713287;
data->l[77] = -4.24547604907725339984;
data->l[78] = -1.29251018758940650066;
data->l[79] = -2.94351345624523830224;
data->l[80] = -2.58761316821790821052;
data->l[81] = -2.44379607179495916824;
data->l[82] = -3.04289903168585951221;
data->l[83] = -2.02040169179486550632;
data->l[84] = -4.55476061459937220377;
data->l[85] = -5.31494308677648774619;
data->l[86] = -4.19873357938485813889;
data->l[87] = -2.62653991447914725299;
data->l[88] = -4.60213282791814215500;
data->l[89] = -2.91464888979993830276;
data->l[90] = -2.64523737629129973570;
data->l[91] = -2.97832277920310550812;
data->l[92] = -2.98319166973028293555;
data->l[93] = -2.16185250095425418593;
data->l[94] = -1.92497822303473342664;
data->l[95] = -1.88798562861858365558;
data->l[96] = -4.10962641920467497414;
data->l[97] = -2.68528667686781119528;
data->l[98] = -4.14817974250168752803;
data->l[99] = -2.83216687895926488849;
data->l[100] = -4.07684939561558401522;
data->l[101] = -3.55535746725127044243;
data->l[102] = -2.19878016870570069941;
data->l[103] = -3.19968012469174301060;
data->l[104] = -4.37737247722521072291;
data->l[105] = -4.29779934643883620993;
data->l[106] = -1.03334633083119697972;
data->l[107] = -0.81390076897596896899;
data->l[108] = -3.21665560538271488866;
data->l[109] = -6.15402655554668953641;
data->l[110] = -2.27813343376604215962;
data->l[111] = -3.94959421817694344981;
data->l[112] = -2.71007130770154303079;
data->l[113] = -3.56779905344119985244;
data->l[114] = -2.59887989285784737348;
data->l[115] = -1.92185833382527415658;
data->l[116] = -2.25868315628457727584;
data->l[117] = -3.80001201590470572000;
data->l[118] = -5.16588491980529873615;
data->l[119] = -2.04071171383146499068;
data->l[120] = -3.57233294118414068663;
data->l[121] = -3.26644422666602718408;
data->l[122] = -1.38692621759718948127;
data->l[123] = -2.12395314556343484114;
data->l[124] = -3.82949064325671040265;
data->l[125] = -3.21998595898643191759;
data->l[126] = -2.14491100577430815477;
data->l[127] = -3.17784524503366672121;
data->l[128] = -3.31168568747398772700;
data->l[129] = -3.29382042875256919601;
data->l[130] = -0.80694092195651689892;
data->l[131] = -1.97807694718309234894;
data->l[132] = -3.91952794097883527868;
data->l[133] = -1.38287735876161921311;
data->l[134] = -1.59701972062903774230;
data->l[135] = -2.32100794362009477112;
data->l[136] = -2.90602673859422067082;
data->l[137] = -2.22282168746895258948;
data->l[138] = -3.28535890011445452785;
data->l[139] = -4.85874907785858312081;
data->l[140] = -2.82738908146895706608;
data->l[141] = -4.93072490032470511778;
data->l[142] = -4.87301112146927994928;
data->l[143] = -2.46269311942567847851;
data->l[144] = -3.92252851768533528087;
data->l[145] = -2.71342609301869819305;
data->l[146] = -2.81303910400445511542;
data->l[147] = -2.94963839207506550721;
data->l[148] = -3.25040905379273858955;
data->l[149] = -2.90144754568281815210;
data->u = (c_float*) c_malloc(150 * sizeof(c_float));
data->u[0] = 2.08716821508799776907;
data->u[1] = 2.13309397630568575721;
data->u[2] = 2.35173615113152001399;
data->u[3] = 3.22258620862348310609;
data->u[4] = 4.02691809599921413110;
data->u[5] = 3.15668313684641610450;
data->u[6] = 3.76474167177344476443;
data->u[7] = 2.69787503458071942219;
data->u[8] = 4.19725545934576516061;
data->u[9] = 2.55911881022287834853;
data->u[10] = 2.56634083263206846937;
data->u[11] = 2.22235289334721475285;
data->u[12] = 3.20239810989186501899;
data->u[13] = 1.95418384623251450982;
data->u[14] = 4.57605835905417279719;
data->u[15] = 1.60348424836770431234;
data->u[16] = 2.18127958996693882554;
data->u[17] = 3.12380369416564596108;
data->u[18] = 3.17132382157554193469;
data->u[19] = 3.83303116920874398232;
data->u[20] = 1.78178934391396825987;
data->u[21] = 1.43997579760315064235;
data->u[22] = 1.89485895646449398200;
data->u[23] = 3.17112364215294917358;
data->u[24] = 3.16832212876711860616;
data->u[25] = 4.75686364247777859759;
data->u[26] = 1.04109369647483807064;
data->u[27] = 4.48403481631758360493;
data->u[28] = 2.48506868020852778045;
data->u[29] = 3.17772932607162417185;
data->u[30] = 3.15298537921691757191;
data->u[31] = 3.15843497989415178395;
data->u[32] = 3.95401468112700449353;
data->u[33] = 3.27874540321524143849;
data->u[34] = 2.90655534156541417445;
data->u[35] = 3.25793222998451525996;
data->u[36] = 3.60921386252208975520;
data->u[37] = 2.20684317595558532332;
data->u[38] = 1.16458920071971983035;
data->u[39] = 4.48735061190155803956;
data->u[40] = 2.73668871870230701049;
data->u[41] = -0.07099517082976225524;
data->u[42] = 1.08045336162845173611;
data->u[43] = 2.09686340177534757956;
data->u[44] = 3.67632853869968734273;
data->u[45] = 3.21420714558397158100;
data->u[46] = 1.50548031434311346821;
data->u[47] = 3.28646168001353711219;
data->u[48] = 3.27063849750589863419;
data->u[49] = 4.09453077553912514475;
data->u[50] = 3.33698018533495677218;
data->u[51] = 2.86564495326209645043;
data->u[52] = 1.18645832068159262640;
data->u[53] = 3.74827877061789482838;
data->u[54] = 3.60099160216810032509;
data->u[55] = 4.16553033877035439048;
data->u[56] = 3.48120159164868070434;
data->u[57] = 1.44874939903375077321;
data->u[58] = 3.01030914968597018699;
data->u[59] = 3.20420616838570060381;
data->u[60] = 3.88211776720046186639;
data->u[61] = 3.50504603497270794676;
data->u[62] = 4.43967990802717338283;
data->u[63] = 3.65031077529283098926;
data->u[64] = 4.03867393640136995714;
data->u[65] = 2.51868566124758652691;
data->u[66] = 3.51545231517025191792;
data->u[67] = 3.99522106473933513726;
data->u[68] = 2.74473999630693032969;
data->u[69] = 3.75682119113716694869;
data->u[70] = 2.19853494512457103838;
data->u[71] = 3.76296179836757493931;
data->u[72] = 3.72804019515156292996;
data->u[73] = 3.29442414687973572640;
data->u[74] = 2.72077405420070084219;
data->u[75] = 3.27748007125185036870;
data->u[76] = 4.34709252637551024634;
data->u[77] = 3.96174501819198443542;
data->u[78] = 2.09761968957606725894;
data->u[79] = 4.69581540595429647311;
data->u[80] = 2.99282670843167863950;
data->u[81] = 4.29697538253160438160;
data->u[82] = 3.43406304771622750138;
data->u[83] = 2.86265013199037721137;
data->u[84] = 4.71055829388397029334;
data->u[85] = 3.66320311505452789191;
data->u[86] = 4.67845162027955652206;
data->u[87] = 3.62800254320246073902;
data->u[88] = 1.13369543874638423198;
data->u[89] = 1.65903317253178772539;
data->u[90] = 4.31604483899205337849;
data->u[91] = 2.93992218589373655036;
data->u[92] = 3.60489435781573863693;
data->u[93] = 3.87207478511764158213;
data->u[94] = 2.42271033498363985714;
data->u[95] = 2.66342091068467778925;
data->u[96] = 0.77278917922504408722;
data->u[97] = 2.55829367109316674345;
data->u[98] = 2.22869066845714902669;
data->u[99] = 2.51507478037541831739;
data->u[100] = 4.52595836072750756784;
data->u[101] = 2.19634693527484348152;
data->u[102] = 2.59398977103008077094;
data->u[103] = 2.30374377225341264719;
data->u[104] = 3.59064272215501478769;
data->u[105] = 2.42413052264691408766;
data->u[106] = 2.14413621780700269781;
data->u[107] = 2.65539553131234606909;
data->u[108] = 2.51281052912103719521;
data->u[109] = 3.83305359474152185228;
data->u[110] = 2.02178784671349731639;
data->u[111] = 2.90070806019362503747;
data->u[112] = 3.95815161766727907633;
data->u[113] = 2.63331836342597691569;
data->u[114] = 4.26245398539829434270;
data->u[115] = 2.62593826470123792305;
data->u[116] = 2.95983675062006890144;
data->u[117] = 4.80868766593572249946;
data->u[118] = 1.99899461274778666997;
data->u[119] = 4.40455236376146341826;
data->u[120] = 1.60817144489194507884;
data->u[121] = 3.23485165021777376637;
data->u[122] = 1.74042141700919916758;
data->u[123] = 3.73331292416611937313;
data->u[124] = 3.73224809549576619361;
data->u[125] = 3.13709885070307770150;
data->u[126] = 1.63518020143116138421;
data->u[127] = 3.18664759182459889075;
data->u[128] = 2.71881665695993435250;
data->u[129] = 2.66542763060391285634;
data->u[130] = 2.85816424078584940816;
data->u[131] = 1.93262915623326114734;
data->u[132] = 2.03339020437731754498;
data->u[133] = 2.05717411736286726054;
data->u[134] = 3.91279382230030048362;
data->u[135] = 2.98003854893579100960;
data->u[136] = 2.63527502956840375958;
data->u[137] = 4.06695902682871057721;
data->u[138] = 3.64262397579621310939;
data->u[139] = 3.78770681300756084653;
data->u[140] = 2.91378930746052722256;
data->u[141] = 3.72419074102282188221;
data->u[142] = 1.91129798402159911674;
data->u[143] = 3.60998204146005186033;
data->u[144] = 1.49803509297239068054;
data->u[145] = 3.71898762059574083949;
data->u[146] = 3.30392509479672291661;
data->u[147] = 3.86918463966925862962;
data->u[148] = 3.73467536606099903551;
data->u[149] = 2.46088829468451431026;
data->q = (c_float*) c_malloc(50 * sizeof(c_float));
data->q[0] = -1.09842992910499415160;
data->q[1] = 0.98958396021513406193;
data->q[2] = 0.71699219928825319581;
data->q[3] = -1.03955386882340294896;
data->q[4] = 0.59600767347861860479;
data->q[5] = -1.96077333782998608491;
data->q[6] = -0.21925127979343958518;
data->q[7] = -0.16931853333883550849;
data->q[8] = -0.12551635398991942139;
data->q[9] = 1.10321832582833412317;
data->q[10] = -1.10138748897282945372;
data->q[11] = -0.23268620656559801940;
data->q[12] = -0.06197048142688561106;
data->q[13] = 0.72136212921336662074;
data->q[14] = 0.23915786590625698338;
data->q[15] = 0.26612327767923521504;
data->q[16] = -0.46506386150426254344;
data->q[17] = 0.06221023568472985182;
data->q[18] = -0.63983376096269162225;
data->q[19] = 1.08494906450618788796;
data->q[20] = -0.86337405908357978124;
data->q[21] = 0.61407762660660270004;
data->q[22] = 1.09915975772035223734;
data->q[23] = -1.36941334393546343406;
data->q[24] = -0.68321702965757347137;
data->q[25] = -0.63659754017116942926;
data->q[26] = -0.64919701449702948981;
data->q[27] = 0.34205797920064096029;
data->q[28] = -1.69465979171629022026;
data->q[29] = -0.40826474945299484620;
data->q[30] = 2.04074025296122218975;
data->q[31] = 0.17289943800008245045;
data->q[32] = -0.57849954526248981157;
data->q[33] = -1.05185438835217737186;
data->q[34] = -1.54100682551918599650;
data->q[35] = 0.37836145528706205399;
data->q[36] = -0.46164662703477449268;
data->q[37] = -0.78628540483192910227;
data->q[38] = -0.60661739053189012161;
data->q[39] = 0.26805500319452596480;
data->q[40] = -1.22399095592147122424;
data->q[41] = 1.55662853131496214942;
data->q[42] = -0.90110579874686402846;
data->q[43] = -1.27800765467802013298;
data->q[44] = 0.08397789167443264757;
data->q[45] = 1.03951848442408745221;
data->q[46] = -0.00075918361696306600;
data->q[47] = 0.78638685528620799747;
data->q[48] = -0.11545375610929509147;
data->q[49] = -0.08264044042635539100;


// Matrix A
//---------
data->A = (csc*) c_malloc(sizeof(csc));
data->A->m = 150;
data->A->n = 50;
data->A->nz = -1;
data->A->nzmax = 76;
data->A->x = (c_float*) c_malloc(76 * sizeof(c_float));
data->A->x[0] = 0.62817365129556224090;
data->A->x[1] = 0.99829832824345665632;
data->A->x[2] = 0.85617478645424061057;
data->A->x[3] = 0.30709500096751285447;
data->A->x[4] = 0.01701035883995860587;
data->A->x[5] = 0.01852109684431468839;
data->A->x[6] = 0.08889269246472908392;
data->A->x[7] = 0.77153761567628464935;
data->A->x[8] = 0.49658073341199604478;
data->A->x[9] = 0.31151271089055265762;
data->A->x[10] = 0.66416201589502765756;
data->A->x[11] = 0.89132487537299875946;
data->A->x[12] = 0.11307689781419150155;
data->A->x[13] = 0.20259428248868149858;
data->A->x[14] = 0.79171431740481934547;
data->A->x[15] = 0.54769479711046142878;
data->A->x[16] = 0.08131208026833125491;
data->A->x[17] = 0.63675122759934144057;
data->A->x[18] = 0.89329540324932987794;
data->A->x[19] = 0.65683568611619480571;
data->A->x[20] = 0.84378663074672277666;
data->A->x[21] = 0.39421117369988134538;
data->A->x[22] = 0.80078036837365174083;
data->A->x[23] = 0.14376545645574700938;
data->A->x[24] = 0.21407910447992184455;
data->A->x[25] = 0.29440983876747017778;
data->A->x[26] = 0.13188054791137937549;
data->A->x[27] = 0.75109840301281083352;
data->A->x[28] = 0.19593772317257551752;
data->A->x[29] = 0.97306084489963962092;
data->A->x[30] = 0.92735272534932544630;
data->A->x[31] = 0.42562850942825647405;
data->A->x[32] = 0.08385076274778957561;
data->A->x[33] = 0.70515463197317129751;
data->A->x[34] = 0.17088793570725235860;
data->A->x[35] = 0.62655805021728760984;
data->A->x[36] = 0.07362779793933782457;
data->A->x[37] = 0.06796620305884903956;
data->A->x[38] = 0.76944369537863299691;
data->A->x[39] = 0.75712268430725637725;
data->A->x[40] = 0.30560331900902049096;
data->A->x[41] = 0.18594059498222870186;
data->A->x[42] = 0.44817066899281987613;
data->A->x[43] = 0.97476021980112226295;
data->A->x[44] = 0.21689682719146852197;
data->A->x[45] = 0.33192763483030729432;
data->A->x[46] = 0.00458600589900903799;
data->A->x[47] = 0.44810918044236736080;
data->A->x[48] = 0.65666995559513263725;
data->A->x[49] = 0.66983027660016802862;
data->A->x[50] = 0.38233276641651703365;
data->A->x[51] = 0.67722390321940695301;
data->A->x[52] = 0.82910403747744054748;
data->A->x[53] = 0.01420791188213987866;
data->A->x[54] = 0.72425308344673056116;
data->A->x[55] = 0.00794109051169678004;
data->A->x[56] = 0.98533520340942326587;
data->A->x[57] = 0.04980836784021613894;
data->A->x[58] = 0.64559530445708446234;
data->A->x[59] = 0.95190009156163013504;
data->A->x[60] = 0.55921025220512077247;
data->A->x[61] = 0.88418694548856258120;
data->A->x[62] = 0.23520979328327484836;
data->A->x[63] = 0.89029874477512449538;
data->A->x[64] = 0.53445470709857889613;
data->A->x[65] = 0.81017303822147435088;
data->A->x[66] = 0.45676104643174897380;
data->A->x[67] = 0.04139675130092934641;
data->A->x[68] = 0.25016029180364851570;
data->A->x[69] = 0.83896149256642782444;
data->A->x[70] = 0.16510411781471978632;
data->A->x[71] = 0.16510411781471978632;
data->A->x[72] = 0.97234259656407207029;
data->A->x[73] = 0.90890625501744926051;
data->A->x[74] = 0.10571723535200583388;
data->A->x[75] = 0.06063952844035780387;
data->A->i = (c_int*) c_malloc(76 * sizeof(c_int));
data->A->i[0] = 39;
data->A->i[1] = 110;
data->A->i[2] = 34;
data->A->i[3] = 61;
data->A->i[4] = 63;
data->A->i[5] = 96;
data->A->i[6] = 94;
data->A->i[7] = 10;
data->A->i[8] = 59;
data->A->i[9] = 90;
data->A->i[10] = 109;
data->A->i[11] = 123;
data->A->i[12] = 149;
data->A->i[13] = 99;
data->A->i[14] = 73;
data->A->i[15] = 130;
data->A->i[16] = 139;
data->A->i[17] = 15;
data->A->i[18] = 44;
data->A->i[19] = 45;
data->A->i[20] = 129;
data->A->i[21] = 17;
data->A->i[22] = 15;
data->A->i[23] = 77;
data->A->i[24] = 5;
data->A->i[25] = 135;
data->A->i[26] = 80;
data->A->i[27] = 5;
data->A->i[28] = 44;
data->A->i[29] = 38;
data->A->i[30] = 144;
data->A->i[31] = 74;
data->A->i[32] = 127;
data->A->i[33] = 32;
data->A->i[34] = 89;
data->A->i[35] = 66;
data->A->i[36] = 110;
data->A->i[37] = 5;
data->A->i[38] = 24;
data->A->i[39] = 52;
data->A->i[40] = 99;
data->A->i[41] = 7;
data->A->i[42] = 33;
data->A->i[43] = 21;
data->A->i[44] = 37;
data->A->i[45] = 13;
data->A->i[46] = 55;
data->A->i[47] = 59;
data->A->i[48] = 107;
data->A->i[49] = 35;
data->A->i[50] = 41;
data->A->i[51] = 123;
data->A->i[52] = 96;
data->A->i[53] = 60;
data->A->i[54] = 12;
data->A->i[55] = 51;
data->A->i[56] = 90;
data->A->i[57] = 12;
data->A->i[58] = 62;
data->A->i[59] = 63;
data->A->i[60] = 105;
data->A->i[61] = 72;
data->A->i[62] = 139;
data->A->i[63] = 61;
data->A->i[64] = 115;
data->A->i[65] = 133;
data->A->i[66] = 106;
data->A->i[67] = 131;
data->A->i[68] = 70;
data->A->i[69] = 122;
data->A->i[70] = 25;
data->A->i[71] = 26;
data->A->i[72] = 91;
data->A->i[73] = 100;
data->A->i[74] = 69;
data->A->i[75] = 103;
data->A->p = (c_int*) c_malloc((50 + 1) * sizeof(c_int));
data->A->p[0] = 0;
data->A->p[1] = 2;
data->A->p[2] = 6;
data->A->p[3] = 7;
data->A->p[4] = 7;
data->A->p[5] = 13;
data->A->p[6] = 14;
data->A->p[7] = 14;
data->A->p[8] = 17;
data->A->p[9] = 19;
data->A->p[10] = 19;
data->A->p[11] = 19;
data->A->p[12] = 21;
data->A->p[13] = 22;
data->A->p[14] = 22;
data->A->p[15] = 22;
data->A->p[16] = 24;
data->A->p[17] = 26;
data->A->p[18] = 27;
data->A->p[19] = 29;
data->A->p[20] = 29;
data->A->p[21] = 31;
data->A->p[22] = 33;
data->A->p[23] = 35;
data->A->p[24] = 37;
data->A->p[25] = 37;
data->A->p[26] = 39;
data->A->p[27] = 41;
data->A->p[28] = 43;
data->A->p[29] = 45;
data->A->p[30] = 48;
data->A->p[31] = 49;
data->A->p[32] = 52;
data->A->p[33] = 52;
data->A->p[34] = 53;
data->A->p[35] = 54;
data->A->p[36] = 54;
data->A->p[37] = 56;
data->A->p[38] = 57;
data->A->p[39] = 61;
data->A->p[40] = 62;
data->A->p[41] = 63;
data->A->p[42] = 66;
data->A->p[43] = 67;
data->A->p[44] = 68;
data->A->p[45] = 69;
data->A->p[46] = 70;
data->A->p[47] = 74;
data->A->p[48] = 74;
data->A->p[49] = 74;
data->A->p[50] = 76;


// Matrix P
//---------
data->P = (csc*) c_malloc(sizeof(csc));
data->P->m = 50;
data->P->n = 50;
data->P->nz = -1;
data->P->nzmax = 55;
data->P->x = (c_float*) c_malloc(55 * sizeof(c_float));
data->P->x[0] = 1.00000000000000000000;
data->P->x[1] = 1.00000000000000000000;
data->P->x[2] = 1.00000000000000000000;
data->P->x[3] = 1.05650000333722360324;
data->P->x[4] = 1.00000000000000000000;
data->P->x[5] = 1.00000000000000000000;
data->P->x[6] = 1.00000000000000000000;
data->P->x[7] = 1.00000000000000000000;
data->P->x[8] = 1.00000000000000000000;
data->P->x[9] = 1.00000000000000000000;
data->P->x[10] = 1.00000000000000000000;
data->P->x[11] = 1.00000000000000000000;
data->P->x[12] = 1.00000000000000000000;
data->P->x[13] = 1.00000000000000000000;
data->P->x[14] = 1.00000000000000000000;
data->P->x[15] = 1.16204719354673269294;
data->P->x[16] = 1.45538640536694940941;
data->P->x[17] = 1.00000000000000000000;
data->P->x[18] = 1.00000000000000000000;
data->P->x[19] = 1.92983780359314405217;
data->P->x[20] = 1.00000000000000000000;
data->P->x[21] = 1.00000000000000000000;
data->P->x[22] = 1.12785765976183527393;
data->P->x[23] = 1.00000000000000000000;
data->P->x[24] = 1.21862563185609262817;
data->P->x[25] = 1.00000000000000000000;
data->P->x[26] = 1.04913053907571218737;
data->P->x[27] = 1.84976892495806022332;
data->P->x[28] = 1.00000000000000000000;
data->P->x[29] = 1.00000000000000000000;
data->P->x[30] = 1.00000000000000000000;
data->P->x[31] = 1.01922690271342308854;
data->P->x[32] = 1.00000000000000000000;
data->P->x[33] = 1.00000000000000000000;
data->P->x[34] = 0.32987968055844241189;
data->P->x[35] = 1.53752406795104334947;
data->P->x[36] = 1.29260484983251022761;
data->P->x[37] = 1.00000000000000000000;
data->P->x[38] = 1.00000000000000000000;
data->P->x[39] = 1.12465245324745710676;
data->P->x[40] = 2.07318952808335055238;
data->P->x[41] = 0.06045007495480932136;
data->P->x[42] = 1.71200796403159127834;
data->P->x[43] = 1.00000000000000000000;
data->P->x[44] = 1.00000000000000000000;
data->P->x[45] = 1.00000000000000000000;
data->P->x[46] = 1.06415606519500283156;
data->P->x[47] = 0.21226035272287230304;
data->P->x[48] = 0.01676298518560175727;
data->P->x[49] = 0.02062512909484691750;
data->P->x[50] = 1.28375234764140655486;
data->P->x[51] = 1.00000000000000000000;
data->P->x[52] = 1.00000000000000000000;
data->P->x[53] = 1.00000000000000000000;
data->P->x[54] = 1.32235064034722427095;
data->P->i = (c_int*) c_malloc(55 * sizeof(c_int));
data->P->i[0] = 0;
data->P->i[1] = 1;
data->P->i[2] = 2;
data->P->i[3] = 3;
data->P->i[4] = 4;
data->P->i[5] = 5;
data->P->i[6] = 6;
data->P->i[7] = 7;
data->P->i[8] = 8;
data->P->i[9] = 9;
data->P->i[10] = 10;
data->P->i[11] = 11;
data->P->i[12] = 12;
data->P->i[13] = 13;
data->P->i[14] = 14;
data->P->i[15] = 15;
data->P->i[16] = 16;
data->P->i[17] = 17;
data->P->i[18] = 18;
data->P->i[19] = 19;
data->P->i[20] = 20;
data->P->i[21] = 21;
data->P->i[22] = 22;
data->P->i[23] = 23;
data->P->i[24] = 24;
data->P->i[25] = 25;
data->P->i[26] = 26;
data->P->i[27] = 27;
data->P->i[28] = 28;
data->P->i[29] = 29;
data->P->i[30] = 30;
data->P->i[31] = 31;
data->P->i[32] = 32;
data->P->i[33] = 33;
data->P->i[34] = 16;
data->P->i[35] = 34;
data->P->i[36] = 35;
data->P->i[37] = 36;
data->P->i[38] = 37;
data->P->i[39] = 38;
data->P->i[40] = 39;
data->P->i[41] = 26;
data->P->i[42] = 40;
data->P->i[43] = 41;
data->P->i[44] = 42;
data->P->i[45] = 43;
data->P->i[46] = 44;
data->P->i[47] = 15;
data->P->i[48] = 26;
data->P->i[49] = 40;
data->P->i[50] = 45;
data->P->i[51] = 46;
data->P->i[52] = 47;
data->P->i[53] = 48;
data->P->i[54] = 49;
data->P->p = (c_int*) c_malloc((50 + 1) * sizeof(c_int));
data->P->p[0] = 0;
data->P->p[1] = 1;
data->P->p[2] = 2;
data->P->p[3] = 3;
data->P->p[4] = 4;
data->P->p[5] = 5;
data->P->p[6] = 6;
data->P->p[7] = 7;
data->P->p[8] = 8;
data->P->p[9] = 9;
data->P->p[10] = 10;
data->P->p[11] = 11;
data->P->p[12] = 12;
data->P->p[13] = 13;
data->P->p[14] = 14;
data->P->p[15] = 15;
data->P->p[16] = 16;
data->P->p[17] = 17;
data->P->p[18] = 18;
data->P->p[19] = 19;
data->P->p[20] = 20;
data->P->p[21] = 21;
data->P->p[22] = 22;
data->P->p[23] = 23;
data->P->p[24] = 24;
data->P->p[25] = 25;
data->P->p[26] = 26;
data->P->p[27] = 27;
data->P->p[28] = 28;
data->P->p[29] = 29;
data->P->p[30] = 30;
data->P->p[31] = 31;
data->P->p[32] = 32;
data->P->p[33] = 33;
data->P->p[34] = 34;
data->P->p[35] = 36;
data->P->p[36] = 37;
data->P->p[37] = 38;
data->P->p[38] = 39;
data->P->p[39] = 40;
data->P->p[40] = 41;
data->P->p[41] = 43;
data->P->p[42] = 44;
data->P->p[43] = 45;
data->P->p[44] = 46;
data->P->p[45] = 47;
data->P->p[46] = 51;
data->P->p[47] = 52;
data->P->p[48] = 53;
data->P->p[49] = 54;
data->P->p[50] = 55;

return data;

}

/* function to clean problem data structure */
void clean_problem_primal_infeasibility(OSQPData * data){

// Clean vectors
c_free(data->l);
c_free(data->u);
c_free(data->q);

//Clean Matrices
c_free(data->A->x);
c_free(data->A->i);
c_free(data->A->p);
c_free(data->A);
c_free(data->P->x);
c_free(data->P->i);
c_free(data->P->p);
c_free(data->P);

c_free(data);

}

/* function to define solutions and additional data struct */
primal_infeasibility_sols_data *  generate_problem_primal_infeasibility_sols_data(){

primal_infeasibility_sols_data * data = (primal_infeasibility_sols_data *)c_malloc(sizeof(primal_infeasibility_sols_data));

data->status_test = OSQP_PRIMAL_INFEASIBLE;

return data;

}

/* function to clean solutions and additional data struct */
void clean_problem_primal_infeasibility_sols_data(primal_infeasibility_sols_data * data){


c_free(data);

}

#endif
