% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmose.interannual-fishing.R
\name{getFishingMortality}
\alias{getFishingMortality}
\title{Get fishing mortality rate.}
\usage{
getFishingMortality(sp, fishing, T, ndt)
}
\arguments{
\item{sp}{Species index (sp0, sp1, sp2, etc.)}

\item{fishing}{List of fishing parameters}

\item{T}{Number of years}

\item{ndt}{Time step}
}
\value{
Fishing mortality rate.
}
\description{
Get fishing mortality rate.
}
\details{
\deqn{F = \frac{B \times \exp^{A+S}}{ndt}}
with \eqn{B}=mortality rate, \eqn{A}=deviates by year, \eqn{S}=deviates by seasons
}
\examples{
{
filename = system.file("extdata", "data_fishing.csv", package="osmose")
conf = readOsmoseConfiguration(filename)
ndt = getOsmoseParameter(conf, "simulation", "time", "ndtperyear")
nyear = getOsmoseParameter(conf, "simulation", "time", "nyear")

fishing = conf$mortality$fishing

fish0 = getFishingMortality("sp0", fishing, nyear, ndt)
}
}
