/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.util;

import fr.ird.osmose.Configuration;
import fr.ird.osmose.Osmose;
import fr.ird.osmose.SchoolSet;
import fr.ird.osmose.Simulation;
import fr.ird.osmose.Species;
import fr.ird.osmose.grid.IGrid;
import fr.ird.osmose.ltl.LTLForcing;
import fr.ird.osmose.util.logging.OLogger;

public class SimulationLinker
extends OLogger {
    private final int rank;

    public SimulationLinker(int rank) {
        super(rank);
        this.rank = rank;
    }

    public final int getRank() {
        return this.rank;
    }

    public Configuration getConfiguration() {
        return Osmose.getInstance().getConfiguration();
    }

    public IGrid getGrid() {
        return Osmose.getInstance().getGrid();
    }

    public Simulation getSimulation() {
        return Osmose.getInstance().getSimulation(this.rank);
    }

    public SchoolSet getSchoolSet() {
        return Osmose.getInstance().getSimulation(this.rank).getSchoolSet();
    }

    public LTLForcing getForcing() {
        return Osmose.getInstance().getSimulation(this.rank).getForcing();
    }

    public Species getSpecies(int index) {
        return Osmose.getInstance().getSimulation(this.rank).getSpecies(index);
    }

    public Species getSpecies(String name) {
        for (int i = 0; i < this.getNSpecies(); ++i) {
            if (!this.getSpecies(i).getName().equalsIgnoreCase(name)) continue;
            return this.getSpecies(i);
        }
        return null;
    }

    public int getNSpecies() {
        return Osmose.getInstance().getConfiguration().getNSpecies();
    }
}

