% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/getMeta.R
\name{importMeta}
\alias{importMeta}
\title{Import monitoring site meta data for the AURN, KCL and SAQN networks}
\usage{
importMeta(source = "aurn", all = FALSE)
}
\arguments{
\item{source}{The data source for the meta data. Can be "aurn",
"kcl" or "saqn"; upper or lower case.}

\item{all}{When \code{all = FALSE} only the site code, site name,
latitude and longitude and site type are imported. Setting
\code{all = TRUE} will import all available meta data.}
}
\value{
A data frame with meta data.
}
\description{
Function to import meta data from UK air pollution monitoring sites
}
\details{
This function imports site meta data from three networks in the
UK: the Defra Automatic Urban and Rural Network (AURN), King's
College London networks and the Scottish Air Quality Network. The
meta data includes site location (latitude, longitude and OS
easting and northing --- the latter for KCL networks), site type
and it's start/close data, as well as other information.

The meta information can usefully be combined with matching air
pollution data and produce maps of concentration --- see examples
below. Note if many sites and/or years of hourly data are imported
it may be better to aggregate first and then combine with the meta
data information.

Thanks go to Dr Ben Barratt (KCL) and Trevor Davies (AEA) for
making these data available.
}
\examples{
## import AQ data and add meta data to data frame
\dontrun{
aq <- importAURN(site = c("kc1", "my1"), year = 2009)
meta <- importMeta(source = "aurn")
aq <- merge(aq, meta, by = "site")
}

## aggregate first before adding meta data (useful for many sites/years)
\dontrun{
aq <- importAURN(site = c("kc1", "my1"), year = 2009)
meta <- importMeta(source = "aurn")
## calculate annual means
annual <- timeAverage(aq, avg.time = "year")
annual <- merge(annual, meta, by = "site")
## make a GoogleMapsPlot
GoogleMapsPlot(annual, pollutant = "no2")
}
}
\author{
David Carslaw
}
\seealso{
\code{\link{importAURN}}, \code{\link{importKCL}} and
\code{\link{importSAQN}} for importing air quality data from each
network, and \code{\link{GoogleMapsPlot}} for plotting
concentrations on a map.
}
\keyword{methods}

