% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.list.R
\name{data.list}
\alias{data.list}
\title{Make a data.list}
\usage{
data.list(...)
}
\arguments{
\item{...}{Should hold: time t, observations as vectors and forecasts as data.frames}
}
\value{
a data.list.
}
\description{
Make a data.list of the vectors and data.frames given.
}
\details{
See the vignette 'setup-data' on how a data.list must be setup.

It's simply a list of class \code{data.list} holding:

  - vector \code{t}

  - vector(s) of observations

  - data.frames (or matrices) of forecast inputs
}
\examples{
# Put together a data.list
# The time vector
time <- seq(ct("2019-01-01"),ct("2019-01-02"),by=3600)
# Observations time series (as vector)
xobs <- rnorm(length(time))
# Forecast input as a data.frame with columns names 'kxx', where 'xx' is the horizon
X <- data.frame(matrix(rnorm(length(time)*3), ncol=3))
names(X) <- pst("k",1:3)

D <- data.list(t=time, xobs=xobs, X=X)

# Check it (see \code{?\link{summary.data.list}})
summary(D)

}
