\name{rf.2pts}
\alias{rf.2pts}
\alias{print.rf.2pts}
\title{Two-point analysis between genetic markers}
\description{
  Performs the two-point (pairwise) analysis proposed by \cite{Wu et al.
    (2002)} between all pairs of markers.
}
\usage{
rf.2pts(w, LOD = 3, max.rf = 0.50, verbose = TRUE)

\method{print}{rf.2pts}(x, mrk1 = NULL, mrk2 = NULL, \dots)
}
\arguments{
  \item{w}{an object of class \code{outcross}.}
  \item{LOD}{minimum LOD Score to declare linkage (defaults to
    \code{3}).}
  \item{max.rf}{maximum recombination fraction to declare linkage
    (defaults to \code{0.50}).}
  \item{verbose}{logical. If \code{TRUE}, current progress is shown; if
    \code{FALSE}, no output is produced.}
  \item{x}{an object of class \code{rf.2pts}.}
  \item{mrk1, mrk2}{optionally, two markers can be specified. If so,
    detailed results of the two-point analysis will be printed for this
    pair. Both arguments can be numeric or character strings indicating
    the numbers/names corresponding to any markers in the input file.}
  \item{\dots}{further arguments, passed to other methods. Currently
    ignored.}
}
\details{
  For \code{n} markers, there are \deqn{\frac{n(n-1)}{2}}{n*(n-1)/2}
  pairs of markers to be analyzed. Therefore, completion of the
  two-point analyses can take a long time.
}
\value{
  An object of class \code{rf.2pts}, which is a list containing the
  following components:
  \item{data.name}{name of the object of class \code{outcross} with the
    raw data.}
  \item{n.mar}{total number of markers.}
  \item{marnames}{marker names, according to the input file.}
  \item{LOD}{minimum LOD Score to declare linkage.}
  \item{max.rf}{maximum recombination fraction to declare linkage.}
  \item{input}{the name of the input file.}
  \item{analysis}{an array with the complete results of the two-point
    analysis for each pair of markers.}

}
\references{
  Wu, R., Ma, C.-X., Painter, I. and Zeng, Z.-B. (2002) Simultaneous
  maximum likelihood estimation of linkage and linkage phases in
  outcrossing species. \emph{Theoretical Population Biology} 61:
  349-363.
}
\note{
  The thresholds used for \code{LOD} and \code{max.rf} will be used in
  subsequent analyses, but can be overriden.
}
\author{Gabriel R A Margarido, \email{gramarga@esalq.usp.br}}
%\seealso{}
\examples{
  data(example_out)

  twopts <- rf.2pts(example_out,LOD=3,max.rf=0.5) # perform two-point analyses
  twopts

  print(twopts,"M1","M2") # detailed results for markers 1 and 2
}
\keyword{utilities}
