% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareFloat.r
\name{compareFloat}
\alias{compareFloat}
\alias{`\%<\%`}
\alias{\%<\%}
\alias{`\%<=\%`}
\alias{\%<=\%}
\alias{`\%==\%`}
\alias{\%==\%}
\alias{`\%>=\%`}
\alias{\%>=\%}
\alias{`\%>\%`}
\alias{\%>\%}
\alias{`\%!=\%`}
\alias{\%!=\%}
\title{Compare values to floating-point precision}
\usage{
compareFloat(x, y, op, tol = .Machine$double.eps^0.5)

x \%<\% y

x \%<=\% y

x \%==\% y

x \%>=\% y

x \%>\% y

x \%!=\% y
}
\arguments{
\item{x, y}{Numeric}

\item{op}{Operator for comparison (must be in quotes): \code{"<"}, \code{">"}, \code{"<="}, \code{">="}, \code{"=="}, or \code{"!="}}

\item{tol}{Tolerance value: The largest absolute difference between \code{x} and \code{y} that is to be considered equality. The default is \code{.Machine$double.eps^0.5}.}
}
\value{
\code{TRUE}, \code{FALSE}, or \code{NA}
}
\description{
These functions compare values while accounting for differences in floating point precision.
}
\examples{
x <- 0.9 - 0.8
y <- 0.8 - 0.7

x < y
x \%<\% y
compareFloat(x, y, "<")

x <= y
x \%<=\% y
compareFloat(x, y, "<=")

x == y
x \%==\% y
compareFloat(x, y, "==")

y > x
y \%>\% x
compareFloat(y, x, ">")

y >= x
y \%>=\% x
compareFloat(y, x, ">=")

x != y
x \%!=\% y
compareFloat(x, y, "!=")

}
