% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ollama.R
\name{create}
\alias{create}
\title{Create a model from a Modelfile}
\usage{
create(
  name,
  modelfile = NULL,
  stream = FALSE,
  path = NULL,
  endpoint = "/api/create",
  host = NULL
)
}
\arguments{
\item{name}{Name of the model to create.}

\item{modelfile}{Contents of the Modelfile as character string. Default is NULL.}

\item{stream}{Enable response streaming. Default is FALSE.}

\item{path}{The path to the Modelfile. Default is NULL.}

\item{endpoint}{The endpoint to create the model. Default is "/api/create".}

\item{host}{The base URL to use. Default is NULL, which uses Ollama's default base URL.}
}
\value{
A response in the format specified in the output parameter.
}
\description{
It is recommended to set \code{modelfile} to the content of the Modelfile rather than just set path.
}
\examples{
\dontshow{if (test_connection()$status_code == 200) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
create("mario", "FROM llama3\nSYSTEM You are mario from Super Mario Bros.")
generate("mario", "who are you?", output = "text")  # model should say it's Mario
delete("mario")  # delete the model created above
\dontshow{\}) # examplesIf}
}
\references{
\href{https://github.com/ollama/ollama/blob/main/docs/api.md#create-a-model}{API documentation}
}
