% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dstat.R
\name{dstat}
\alias{dstat}
\title{Tomoka Ohta's D Statistics}
\usage{
dstat(index, data_set, tot_maf = 0.1, pop_maf = 0.05)
}
\arguments{
\item{index}{A two-element vector of column names or numbers for which
Ohta's D Statistics will be computed.}

\item{data_set}{Matrix containing genotype data with individuals as rows and
loci as columns. Genotypes should be coded as 0 (homozygous), 1 (heterozygous),
or 2 (homozygous). Rownames must be subpopulation names and column names
should be marker names.}

\item{tot_maf}{Minimum minor allele frequency across the total population
for a marker to be included in the analysis.}

\item{pop_maf}{Minimum minor allele frequency across a subpopulation for
that subpopulation to be included in analysis.}
}
\value{
nPops Number of subpopulations used for computation, after filtering.

D2it A measure of the correlation of alleles at two loci on the same
gametes in a subpopulation relative to their expectation according to allele
frequencies in the total population.

D2is Expected variance of LD for subpopulations.

D2st Expected correlation of alleles in a subpopulation relative to their
expected correlation in the total population.

Dp2st Variance of LD for the total population computed over alleles only.

Dp2is Correlation of alleles at two loci on the same gamete in subpopulations
relative to their expected correlation in the total population.
}
\description{
Implements Ohta's D statistics for a pair of loci. Statistics are returned in a vector in the following order:
Number of populations, D2it, D2is, D2st, D'2st, D'2is.
}
\examples{
data(beissinger_data)
dstat(index = c(5,6), data_set = beissinger_data)

}
\references{
Beissinger et al. (2016) Heredity. (https://www.nature.com/articles/hdy201581) &
Ohta. (1982) Proc. Natl. Acad. Science. (http://www.pnas.org/content/79/6/1940)
}
