% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppt_ph_with_methods.R
\name{ph_with_table}
\alias{ph_with_table}
\alias{ph_with_table_at}
\title{add table}
\usage{
ph_with_table(x, value, type = "body", index = 1, header = TRUE,
  first_row = TRUE, first_column = FALSE, last_row = FALSE,
  last_column = FALSE, location = NULL)

ph_with_table_at(x, value, left, top, width, height, header = TRUE,
  first_row = TRUE, first_column = FALSE, last_row = FALSE,
  last_column = FALSE)
}
\arguments{
\item{x}{a pptx device}

\item{value}{data.frame}

\item{type}{placeholder type (i.e. 'body', 'title')}

\item{index}{placeholder index (integer). This is to be used when a placeholder type
is not unique in the current slide, e.g. two placeholders with type 'body', the first
one will be added with index 1 and the second one with index 2.
It is recommanded to use argument \code{location} instead of \code{type} and
\code{index}.}

\item{header}{display header if TRUE}

\item{first_row, last_row, first_column, last_column}{logical for PowerPoint table options}

\item{location}{a placeholder location object. This is a convenient
argument that can replace usage of arguments \code{type} and \code{index}.
See \link{ph_location_type}, \link{ph_location}, \link{ph_location_label},
\link{ph_location_left}, \link{ph_location_right}, \link{ph_location_fullsize}.}

\item{left, top}{location of the new shape on the slide}

\item{width, height}{shape size in inches}
}
\description{
add a table as a new shape in the current slide.
}
\examples{
library(magrittr)

doc <- read_pptx() \%>\%
  add_slide(layout = "Title and Content", master = "Office Theme") \%>\%
  ph_with_table(value = mtcars[1:6,], type = "body",
    last_row = FALSE, last_column = FALSE, first_row = TRUE)

print(doc, target = tempfile(fileext = ".pptx"))

library(magrittr)

doc <- read_pptx() \%>\%
  add_slide(layout = "Title and Content", master = "Office Theme") \%>\%
  ph_with_table_at(value = mtcars[1:6,],
    height = 4, width = 8, left = 4, top = 4,
    last_row = FALSE, last_column = FALSE, first_row = TRUE)

print(doc, target = tempfile(fileext = ".pptx"))
}
