% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fp_text.R
\name{fp_text}
\alias{fp_text}
\alias{format.fp_text}
\alias{print.fp_text}
\alias{update.fp_text}
\title{Text formatting properties}
\usage{
fp_text(color = "black", font.size = 10, bold = FALSE, italic = FALSE,
  underlined = FALSE, font.family = "Arial", vertical.align = "baseline",
  shading.color = "transparent")

\method{format}{fp_text}(x, type = "wml", ...)

\method{print}{fp_text}(x, ...)

\method{update}{fp_text}(object, color, font.size, bold = FALSE,
  italic = FALSE, underlined = FALSE, font.family, vertical.align,
  shading.color, ...)
}
\arguments{
\item{color}{font color - a single character value specifying
a valid color (e.g. "#000000" or "black").}

\item{font.size}{font size (in point) - 0 or positive integer value.}

\item{bold}{is bold}

\item{italic}{is italic}

\item{underlined}{is underlined}

\item{font.family}{single character value specifying font name.}

\item{vertical.align}{single character value specifying font vertical alignments.
Expected value is one of the following : default \code{'baseline'}
or \code{'subscript'} or \code{'superscript'}}

\item{shading.color}{shading color - a single character value specifying
a valid color (e.g. "#000000" or "black").}

\item{x}{\code{fp_text} object}

\item{type}{output type - one of 'wml', 'pml', 'html'.}

\item{...}{further arguments - not used}

\item{object}{\code{fp_text} object to modify}

\item{format}{format type, wml for MS word, pml for
MS PowerPoint and html.}
}
\value{
a \code{fp_text} object
}
\description{
Create a \code{fp_text} object that describes
text formatting properties.
}
\examples{
print( fp_text (color="red", font.size = 12) )
}
