% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_posterior.R
\name{get_posterior}
\alias{get_posterior}
\alias{get_post_samples}
\alias{get_post_summary}
\title{Extract posterior samples or summary of parameters from a model-fit object.}
\usage{
get_post_samples(
  fit,
  parameter = c("z", "pi", "phi", "theta", "psi", "alpha", "beta", "gamma",
    "alpha_shared", "beta_shared", "gamma_shared", "Mu", "sigma", "rho"),
  output_dataframe = FALSE
)

get_post_summary(
  fit,
  parameter = c("z", "pi", "phi", "theta", "psi", "alpha", "beta", "gamma",
    "alpha_shared", "beta_shared", "gamma_shared", "Mu", "sigma", "rho"),
  output_dataframe = FALSE
)
}
\arguments{
\item{fit}{An \code{occumbFit} object.}

\item{parameter}{A string of parameter name. See Details for possible choices
and corresponding parameters.}

\item{output_dataframe}{If \code{TRUE}, results are returned in data frame
format.}
}
\value{
By default, \code{get_post_samples()} returns a vector, matrix, or array of
posterior samples for a selected parameter.

\code{get_post_summary()} returns, by default, a table (matrix) of the
posterior summary of the selected parameters. The elements of the posterior
summary are the same as those obtained with the \code{\link[jagsUI]{jags}()}
function in the \code{jagsUI} package: they include the mean, standard
deviation, percentiles of posterior samples; the \code{Rhat} statistic;
the effective sample size, \code{n.eff}; \code{overlap0}, which checks if 0
falls in the parameter's 95\% credible interval; and the proportion of the
posterior with the same sign as the mean, \code{f}.

The \code{dimension} and \code{label} attributes of the output object
provide information regarding the dimensions of the parameter.

When \code{output_dataframe = TRUE}, the results are returned in data
frame format where the attributes obtained when
\code{output_dataframe = FALSE} are incorporated into the table.
}
\description{
\code{get_post_samples()} extracts posterior samples of the specified
parameters from a model-fit object.

\code{get_post_summary()} extracts posterior summary of the specified
parameters from a model-fit object.
}
\details{
The functions return posterior samples or a summary of one of the
following parameters in the model, stored in the model-fit object
\code{fit}:
\describe{
\item{\code{z}}{Site occupancy status of species.}
\item{\code{pi}}{Multinomial probabilities of species sequence read counts.}
\item{\code{phi}}{Sequence relative dominance of species.}
\item{\code{theta}}{Sequence capture probabilities of species.}
\item{\code{psi}}{Site occupancy probabilities of species.}
\item{\code{alpha}}{Species-specific effects on sequence relative dominance
(\code{phi}).}
\item{\code{beta}}{Species-specific effects on sequence capture
probabilities (\code{theta}).}
\item{\code{gamma}}{Species-specific effects on site occupancy
probabilities (\code{psi}).}
\item{\code{alpha_shared}}{Effects on sequence relative dominance
(\code{phi}) common across species.}
\item{\code{beta_shared}}{Effects on sequence capture probabilities
(\code{theta}) that are common across species.}
\item{\code{gamma_shared}}{Effects on site occupancy probabilities
(\code{psi}) that are common across species.}
\item{\code{Mu}}{Community-level averages of species-specific effects
(\code{alpha}, \code{beta}, \code{gamma}).}
\item{\code{sigma}}{Standard deviations of species-specific effects
(\code{alpha}, \code{beta}, \code{gamma}).}
\item{\code{rho}}{Correlation coefficients of the species-specific effects
(\code{alpha}, \code{beta}, \code{gamma}).}
}
See \href{https://fukayak.github.io/occumb/articles/model_specification.html}{the package vignette}
for details of these parameters.

The parameter may have dimensions corresponding to species, sites,
replicates, and effects (covariates), and when
\code{output_dataframe = FALSE}, the \code{dimension} and \code{label}
attributes are added to the output object to inform these dimensions.
If the sequence read count data \code{y} have species, site, or replicate
names appended as the \code{dimnames} attribute (see Details in
\code{\link{occumbData}()}), they are copied into the \code{label}
attribute of the returned object.
}
\examples{
\donttest{
# Generate the smallest random dataset (2 species * 2 sites * 2 reps)
I <- 2 # Number of species
J <- 2 # Number of sites
K <- 2 # Number of replicates
y_named <- array(sample.int(I * J * K), dim = c(I, J, K))
dimnames(y_named) <- list(c("species 1", "species 2"),
                          c("site 1", "site 2"), NULL)
data_named <- occumbData(y = y_named)

# Fitting a null model
fit <- occumb(data = data_named, n.iter = 10100)

# Extract posterior samples
(post_sample_z <- get_post_samples(fit, "z"))
# Look dimensions of the parameter
attributes(post_sample_z)

# Extract posterior summary
(post_summary_z <- get_post_summary(fit, "z"))
# Look dimensions of the parameter
attributes(post_summary_z)
}
}
