% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{docdb_create}
\alias{docdb_create}
\title{Create documents in a database}
\usage{
docdb_create(src, key, value, ...)
}
\arguments{
\item{src}{Source object, result of call to any of functions
\code{\link[=src_mongo]{src_mongo()}}, \code{\link[=src_sqlite]{src_sqlite()}}, \code{\link[=src_elastic]{src_elastic()}}, \code{\link[=src_couchdb]{src_couchdb()}}
or \code{\link[=src_postgres]{src_postgres()}}}

\item{key}{(character) A key as name of the container
(corresponds to parameter \code{collection} for MongoDB,
\code{dbname} for CouchDB, \code{index} for Elasticsearch and to
a table name for SQLite and for PostgreSQL)}

\item{value}{The data to be created in the database:
a single data.frame, a JSON string or a list}

\item{...}{Passed to functions:
\itemize{
\item CouchDB: \code{\link[sofa:db_bulk_create]{sofa::db_bulk_create()}}
\item Elasticsearch: \link[elastic:docs_bulk]{elastic::docs_bulk}
\item MongoDB: \code{\link[mongolite:mongo]{mongolite::mongo()}}
\item SQLite: ignored
\item PostgreSQL: ignored
}}
}
\value{
(integer) Number of successfully created documents
}
\description{
A message is emitted if the container \code{key} already exists.
}
\section{Identifiers}{

Any _id's in \code{value} will be used as _id's and primary index
in the database. If there are no _id's in \code{value},
row names (if any exist) will be used as _id's,
or random _id's will be created (using
\code{\link[uuid:UUIDgenerate]{uuid::UUIDgenerate()}} with \code{use.time = TRUE}).

A warning is emitted if a document(s) with _id's already
exist in \code{value} and that document in \code{value} is not newly
created in the database; use \code{\link[=docdb_update]{docdb_update()}} to update
such document(s).
}

\examples{
\dontrun{
src <- src_sqlite()
docdb_create(src, key = "diamonds_small",
  value = as.data.frame(diamonds[1:3000L,]))
head(docdb_get(src, "diamonds_small"))
docdb_create(src, key = "contacts", value = contacts)
docdb_get(src, "contacts")[["friends"]]
}

}
