% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input.R
\name{find_file_name}
\alias{find_file_name}
\title{Find a database file name}
\usage{
find_file_name(year = NULL, file_type = "details")
}
\arguments{
\item{year}{A four-digit numeric or character string giving the year for which
the user would like to download data.}

\item{file_type}{A character string specifying the type of file you would
like to pull. Choices include: "details" (the default), "fatalities", or
"locations".}
}
\description{
This function will find the name of the detailed file from Storm Events
Database for a specific year and specific type of file. This file name
can then be used (in other functions) to download the data for a given year.
}
\details{
This function creates a list of all file names available on
   \url{https://www1.ncdc.noaa.gov/pub/data/swdi/stormevents/csvfiles/}
   and then uses regular expressions to search that list for the name
   of the file for the year and type of file requested. While the files
   are named consistently, part of the name includes the date the file
   was last updated, which changes frequently. The method used here is
   robust to changes in this "last updated" date within the file names.
}
\examples{
\dontrun{
find_file_name(year = 1999)
find_file_name(year = 2003, file_type = "fatalities")
}

}
