% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{funs.base.class.spec}
\alias{funs.base.class.spec}
\alias{base.class.spec.ct}
\alias{base.class.spec}
\title{Base Class-specific Chi-square Tests based on NNCTs}
\usage{
base.class.spec.ct(ct, covN)

base.class.spec(dat, lab, ...)
}
\arguments{
\item{ct}{A nearest neighbor contingency table, used in \code{base.class.spec.ct} only}

\item{covN}{The \eqn{k^2 \times k^2} covariance matrix of row-wise vectorized entries of NNCT, \code{ct} ;
used in \code{base.class.spec.ct} only.}

\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point,
used in \code{base.class.spec} only}

\item{lab}{The \code{vector} of class labels (numerical or categorical), used in \code{base.class.spec} only}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function. 
used in \code{base.class.spec} only}
}
\value{
A \code{list} with the elements
\item{type}{Type of the class-specific test, which is \code{"base"} for this function}
\item{statistic}{The \code{vector} of base class-specific test statistics}
\item{stat.names}{Name of the test statistics}
\item{p.value}{The \code{vector} of \eqn{p}-values for the hypothesis test}
\item{df}{Degrees of freedom for the chi-squared test, which is \eqn{k-1} for this function.}
\item{estimate}{Estimates of the parameters, NNCT, i.e., matrix of the observed \eqn{N_{ij}} values
which is the NNCT.}
\item{null.value}{Matrix of hypothesized null values for the parameters which are expected values of 
the \eqn{N_{ij}} values in the NNCT.}
\item{null.name}{Name of the null values}
\item{method}{Description of the hypothesis test}
\item{ct.name}{Name of the contingency table, \code{ct}, returned by \code{base.class.spec.ct} only}
\item{data.name}{Name of the data set, \code{dat}, returned by \code{base.class.spec} only}
}
\description{
Two functions: \code{base.class.spec.ct} and \code{base.class.spec}.

Both functions are objects of class \code{"classhtest"} but with different arguments (see the parameter list below).
Each one performs class specific segregation tests due to Dixon for \eqn{k \ge 2} classes. That is,
each one performs hypothesis tests of deviations of 
entries in each row of NNCT from the expected values under RL or CSR for each row. 
Recall that row labels in the NNCT are base class labels.
The test for each row \eqn{i} is based on the chi-squared approximation of the corresponding quadratic form
and are due to \insertCite{dixon:NNCTEco2002;textual}{nnspat}.

Each function yields the test statistic, \eqn{p}-value and \code{df} for each base class \eqn{i}, description of the 
alternative with the corresponding null values (i.e. expected values) for the row \eqn{i}, estimates for the entries in row \eqn{i}
for \eqn{i=1,\ldots,k}. The functions also provide names of the test statistics, the method and the data set used.

The null hypothesis for each row is that the corresponding \eqn{N_{ij}} entries in row \eqn{i} are equal to their 
expected values under RL or CSR.

See also (\insertCite{dixon:NNCTEco2002,ceyhan:stat-neer-class2009;textual}{nnspat})
and the references therein.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)
covN<-cov.nnct(ct,varN,Qv,Rv)

base.class.spec(Y,cls)
base.class.spec.ct(ct,covN)
base.class.spec(Y,cls,method="max")

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
ct<-nnct(ipd,fcls)

base.class.spec(Y,fcls)
base.class.spec.ct(ct,covN)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)
covN<-cov.nnct(ct,varN,Qv,Rv)

base.class.spec(Y,cls)
base.class.spec.ct(ct,covN)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{NN.class.spec.ct}}, \code{\link{NN.class.spec}}, \code{\link{class.spec.ct}} 
and \code{\link{class.spec}}
}
\author{
Elvan Ceyhan
}
