% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addBaseline.R
\name{addBaselineExp}
\alias{addBaselineExp}
\title{Add baseline that decays exponential with time}
\usage{
addBaselineExp(ui, effect = "effect", eb = "Eb", time = "time", kb = "kb")
}
\arguments{
\item{ui}{rxode2 model}

\item{effect}{the effect variable that will be modeled}

\item{eb}{baseline constant parameter}

\item{time}{the time or other variable used for baseline decay}

\item{kb}{the first order baseline decay constant}
}
\value{
model with baseline constant
}
\description{
Add baseline that decays exponential with time
}
\examples{
 readModelDb("PK_2cmt_no_depot") |>
  addDirectLin() |>
  convertQuad() |>
  addBaselineExp()
}
\seealso{
Other PD: 
\code{\link{addBaseline1exp}()},
\code{\link{addBaselineConst}()},
\code{\link{addBaselineLin}()},
\code{\link{addDirectLin}()},
\code{\link{convertEmax}()},
\code{\link{convertLogLin}()},
\code{\link{convertQuad}()}
}
\author{
Matthew L. Fidler
}
\concept{PD}
