% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/statistics.R
\docType{methods}
\name{dist}
\alias{dist}
\alias{dist,CompositionMatrix-method}
\title{Distances}
\usage{
\S4method{dist}{CompositionMatrix}(x, method = "euclidean", diag = FALSE, upper = FALSE, p = 2)
}
\arguments{
\item{x}{A \code{\linkS4class{CompositionMatrix}} object.}

\item{method}{A \code{\link{character}} string specifying the distance measure to be
used. See \code{\link[stats:dist]{stats::dist()}} for the available distances.}

\item{diag}{A \code{\link{logical}} scalar indicating whether the diagonal of the
distance matrix should be printed.}

\item{upper}{A \code{\link{logical}} scalar indicating whether the upper triangle of
the distance matrix should be printed.}

\item{p}{An \code{\link{integer}} giving the power of the Minkowski distance.}
}
\value{
A \code{\link[stats:dist]{stats::dist}} object.
}
\description{
Computes the log-ratio variance matrix.
}
\details{
Distances are computed on \link[=transform_clr]{CLR-transformed} data.
}
\examples{
## Data from Aitchison 1986
data("hongite")

## Coerce to compositional data
coda <- as_composition(hongite)

## Aitchison distance
## (euclidean distance between CLR-transformed compositions)
d <- dist(coda)

## Cluster dendrogram
h <- hclust(d, method = "ward.D2")
plot(h)
}
\references{
Aitchison, J. (1986). \emph{The Statistical Analysis of Compositional Data}.
London: Chapman and Hall, p. 64-91.

Greenacre, M. J. (2019). \emph{Compositional Data Analysis in Practice}.
Boca Raton: CRC Press.
}
\seealso{
\code{\link[stats:dist]{stats::dist()}}

Other statistics: 
\code{\link{aggregate}()},
\code{\link{covariance}()},
\code{\link{mahalanobis}()},
\code{\link{margin}()},
\code{\link{mean}()},
\code{\link{metric_var}()},
\code{\link{scale}()},
\code{\link{variation}()}
}
\author{
N. Frerebeau
}
\concept{statistics}
