% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggcentrality.R
\name{ggconn_area}
\alias{ggconn_area}
\title{Calculate connectedness to a specific vertex for vertices linked to a sf
object}
\usage{
ggconn_area(n, m, id, lkp = NULL, m_name = NULL, n_name = "vertex.names")
}
\arguments{
\item{n}{A \code{network} or \code{igraph} object.}

\item{m}{A \code{sf} object.}

\item{id}{The identifier (as vertex attribute \code{n_name} of object \code{n})
of the feature that needs to be checked for connections.}

\item{lkp}{An optional lookup table.}

\item{m_name}{Optional \code{character}, name of field in \code{m} and of
column in \code{lkp}.}

\item{n_name}{Optional \code{character}, name of vertex attribute in \code{n}
and of column in \code{lkp}.}
}
\value{
An \code{sf} object, input \code{m} with an added column
\code{conn_area} with an indicator variable set to 1 if the feature is
connected to the feature with vertex id \code{id}, 0 otherwise.
In directed graphs, only outgoing links are considered a connection.
Any existing column with the same name will be overwritten, the result will
contain only the features linked to vertices in input. If the vertex
\code{id} is not present in object \code{n}, \code{conn_area} will be set to
0 for all vertices.
}
\description{
Given a \code{sf} object with features that can be linked to a \code{network}
or \code{igraph} object and given a node with id \code{id} in said graph that
can be linked to the \code{sf} object, obtain an indicator variable denoting,
for each node, a connection to \code{id}.
}
\examples{
net=network::network(matrix(c(0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0), nrow=4, byrow=TRUE))
network::set.vertex.attribute(net, "name", value=c("a", "b", "c", "d"))
wkb = structure(list("01010000204071000000000000801A064100000000AC5C1641",
"01010000204071000000000000801A084100000000AC5C1441",
"01010000204071000000000000801A044100000000AC5C1241",
"01010000204071000000000000801A024100000000AC5C1841"), class = "WKB")
map=sf::st_sf(id=c("a1", "b2", "c3", "d4"), sf::st_as_sfc(wkb, EWKB=TRUE))
lkptbl=data.frame(id=c("a1", "b2", "c3", "d4"), name=c("a", "b", "c", "d"))
ggconn_area(net, map, "b", lkptbl, "id", "name")
}
