% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path.R
\name{path}
\alias{path}
\title{Extract Path Model Equation}
\usage{
path(x, from, to, round = 3)
}
\arguments{
\item{x}{object of class "netSEM", which is the return value of function \code{netSEMp1}.}

\item{from}{character string. Name of the predictor.}

\item{to}{character string. Name of the endogenous variable.}

\item{round}{a positive integer. The coefficients are rounded to this decimal place.}
}
\value{
a list of the following items: 
\itemize{
  \item "model": the best fitted model.
  \item "model.print": a character string of the model equation.
}
}
\description{
Extract and display an equation of a pairwise path between two variables.
}
\details{
Extract the "best" model from principle 1 between any two variables. 
The model name and the model equation are printed on screen. 
The model coefficients, as well as the model R object are also returned.
}
\examples{
\dontrun{
## Load the sample acrylic data set
data(acrylic)

# Run netSEM principle one
ans <- netSEMp1(acrylic)

# Extract relations between IrradTot and IAD2
cf <- path(ans, from = "IrradTot", to = "IAD2")
print(cf)
}
}
\seealso{
\link[netSEM]{netSEMp1}
}
