% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_from_p.R
\name{ci_from_p}
\alias{ci_from_p}
\title{CI from p value}
\usage{
ci_from_p(diff, p_value, ci = 0.95)
}
\arguments{
\item{diff}{Difference (number) around which the CI is to be calculated.}

\item{p_value}{The p value for CI calculation.}

\item{ci}{Numeric; confidence level for the returned CIs (\code{.95} per
default).}
}
\value{
CI limits  as named numeric vector with two elements.
}
\description{
Calculates approximate confidence interval (CI) for any given
 difference, based on the difference value and p value, according to Altman &
 Bland (2011).
}
\note{
Check the Altman & Bland (2011) paper for details! (The calculation for
proportions is not implemented here.)
}
\examples{

# Example 1
# calculate proportion difference test
proptest_stat = prop.test(x = c(49, 40), n = c(50, 50))

# calculate proportion difference
my_diff = 49/50-40/50

# calculate approximate CI
ci_from_p(my_diff, proptest_stat$p.value)

# returned CI should be very similar to the actual CI
proptest_stat$conf.int


# Example 2
# generate random data
v1 = stats::rnorm(190, 40, 60)
v2 = stats::rnorm(170, 50, 45)

# calculate t-test
ttest_stat = stats::t.test(v1, v2)

# calculate mean difference
my_diff = mean(v1) - mean(v2)

# calculate approximate CI
ci_from_p(my_diff, ttest_stat$p.value)

# returned CI should be similar to the actual CI
ttest_stat$conf.int

}
\references{
Altman, D. G., & Bland, J. M. (2011). How to obtain the confidence interval
from a P value. Bmj, 343(d2090). \doi{https://doi.org/10.1136/bmj.d2090}
}
