% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_repos.R
\name{local_reg_dir_for_url}
\alias{local_reg_dir_for_url}
\title{Standard local checkout location for extra registration directories}
\usage{
local_reg_dir_for_url(url = NULL)
}
\arguments{
\item{url}{Character vector containing a url. When \code{url=NULL} defaults
to giving the base path.}
}
\description{
Standard local checkout location for extra registration directories
}
\details{
When called without any argument returns the root directory that
  will be inspected for extra registrations. You can put a sub-folder
  yourself there manually and then call add_reg_folders, but you are much
  better off in general using \code{\link{download_reg_repo}} to install from
  a github repository such as this one of ours:.
  \href{https://github.com/jefferislab/BridgingRegistrations}{jefferislab/BridgingRegistrations}


  Note that this folder will always be the same place on a machine i.e. this
  defines a consistent, persistent location on disk to store data across
  sessions.

  When called with a url, a SHA1 hash will be calculated for the URL and
  appended to the basepath. This should ensure that locations derived from
  different URLs do not clash.
}
\seealso{
\code{\link{download_reg_repo}}
}
