% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{remove_redundancy}
\alias{remove_redundancy}
\alias{remove_redundancy,spec_tbl_df-method}
\alias{remove_redundancy,tbl_df-method}
\title{Drop redundant elements (e.g., elements) for which feature (e.g., feature/gene) aboundances are correlated}
\usage{
remove_redundancy(
  .data,
  .element,
  .feature,
  .value,
  of_elements = TRUE,
  correlation_threshold = 0.9,
  top = Inf,
  transform = NULL
)

\S4method{remove_redundancy}{spec_tbl_df}(
  .data,
  .element,
  .feature,
  .value,
  of_elements = TRUE,
  correlation_threshold = 0.9,
  top = Inf,
  transform = NULL
)

\S4method{remove_redundancy}{tbl_df}(
  .data,
  .element,
  .feature,
  .value,
  of_elements = TRUE,
  correlation_threshold = 0.9,
  top = Inf,
  transform = NULL
)
}
\arguments{
\item{.data}{A `tbl` formatted as | <element> | <feature> | <value> | <...> |}

\item{.element}{The name of the element column (normally elements).}

\item{.feature}{The name of the feature column (normally features)}

\item{.value}{The name of the column including the numerical value the clustering is based on (normally feature value)}

\item{of_elements}{A boolean. In case the input is a nanny object, it indicates Whether the element column will be element or feature column}

\item{correlation_threshold}{A real number between 0 and 1. For correlation based calculation.}

\item{top}{An integer. How many top genes to select for correlation based method}

\item{transform}{A function to use to tranforma the data internalli (e.g., log1p)}
}
\value{
A tbl object with with dropped recundant elements (e.g., elements).

A tbl object with with dropped recundant elements (e.g., elements).

A tbl object with with dropped recundant elements (e.g., elements).
}
\description{
remove_redundancy() takes as imput a `tbl` formatted as | <element> | <feature> | <value> | <...> | for correlation method, and returns a `tbl` with dropped elements (e.g., elements). The backend function used is widyr::pairwise_cor (David Robinson, 2020)
}
\details{
\lifecycle{maturing}

This function removes redundant elements from the original data set (e.g., elements or features). For example, if we want to define cell-type specific signatures with low element redundancy. This function returns a tibble with dropped recundant elements (e.g., elements). Two redundancy estimation approaches are supported: (i) removal of highly correlated clusters of elements (keeping a representative) with method="correlation"; (ii) removal of most proximal element pairs in a reduced dimensional space.
}
\examples{



remove_redundancy(mtcars_tidy, car_model, feature, value)


}
