% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miss-scan-count.R
\name{miss_scan_count}
\alias{miss_scan_count}
\title{Search and present different kinds of missing values}
\usage{
miss_scan_count(data, search)
}
\arguments{
\item{data}{data}

\item{search}{values to search for}
}
\value{
a dataframe of the occurrences of the values you searched for
}
\description{
Searching for different kinds of missing values is really annoying. If
you have values like -99 in your data, when they shouldn't be there,
or they should be encoded as missing, it can be difficult to ascertain
if they are there, and if so, where they are. \code{miss_scan_count} makes it
easier for users to search for particular occurrences of these values
across their variables.
}
\examples{

dat_ms <- tibble::tribble(~x,  ~y,    ~z,
                         1,   "A",   -100,
                         3,   "N/A", -99,
                         NA,  NA,    -98,
                         -99, "E",   -101,
                         -98, "F",   -1)

miss_scan_count(dat_ms,-99)
miss_scan_count(dat_ms,c(-99,-98))
miss_scan_count(dat_ms,c("-99","-98","N/A"))
miss_scan_count(dat_ms,common_na_strings)

}
\seealso{
\url{miss_case_pct} \url{miss_case_prop} \code{\link[=miss_prop_summary]{miss_prop_summary()}} \url{miss_case_summary} \url{miss_case_table} \url{miss_summary} \url{miss_var_pct} \url{miss_var_prop} \url{miss_var_run} \url{miss_var_span} \url{miss_var_summary} \url{miss_var_table}
}
