## ----, echo = FALSE, message = FALSE----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
library(myTAI)
options(width = 750)
knitr::opts_chunk$set(
  comment = "#>",
  error = FALSE,
  tidy = FALSE)

## ----,eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  library(myTAI)
#  
#  # load an example PhyloExpressionSet stored in the myTAI package
#  data(PhyloExpressionSetExample)
#  
#  # load an example DivergenceExpressionSet stored in the myTAI package
#  data(DivergenceExpressionSetExample)

## ----,eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  
#  head(PhyloExpressionSetExample, 3) # head of an example standard PhyloExpressionSet
#  

## ----,eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # used by all myTAI functions to check the validity of the PhyloExpressionSet standard
#  is.ExpressionSet(PhyloExpressionSetExample)

## ----,eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # used a non standard PhyloExpressionSet
#  head(PhyloExpressionSetExample[ , 2:5], 2)

## ----, error = TRUE,eval=FALSE----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  is.ExpressionSet(PhyloExpressionSetExample[ , 2:5])

## ----,eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  head(DivergenceExpressionSetExample, 3) # head of an example standard DivergenceExpressionSet

## ----,eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # install.packages("gdata")
#  library(gdata)
#  url_phyloSet <- "http://files.figshare.com/1798296/Supplementary_table_S3.xls"
#  
#  download.file( url      =  url_phyloSet,
#                 destfile = "PhyloExpressionSetTables.xls" )
#  
#  Athaliana_PhyloExpressionSet <- read.xls("PhyloExpressionSetTables.xls", sheet = 3)
#  
#  head(Athaliana_PhyloExpressionSet)
#  

## ----,eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Compute the Transcriptome Age Index of the downloaded PhyloExpressionSet
#  TAI(Athaliana_PhyloExpressionSet)

## ----,eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  head(Athaliana_PhyloExpressionSet[ , c("Phylostratum","GeneID")])

## ----,eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  head(DivergenceExpressionSetExample[ , c("Divergence.stratum","GeneID")])

## ----, eval=FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  head(DivergenceExpressionSetExample[ , 2:9])

## ----,eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # load a standard PhyloExpressionSet
#  data(PhyloExpressionSetExample)
#  
#  # in a standard PhyloExpressionSet,
#  # column one and column two denote a standard
#  # Phylostratigraphic Map
#  PhyloMap <- PhyloExpressionSetExample[ , 1:2]
#  
#  # look at the Phylostratigraphic Map standard
#  head(PhyloMap)

## ----,eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # in a standard PhyloExpressionSet, column two combined
#  # with column 3 - N denote a standard ExpressionMatrix
#  ExpressionMatrixExample <- PhyloExpressionSetExample[ , c(2,3:9)]
#  
#  head(ExpressionMatrixExample)

## ----,eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # now we can use the MatchMap function to merge both data sets
#  # to obtain a standard PhyloExpressionSet
#  
#  PES <- MatchMap(PhyloMap, ExpressionMatrixExample)
#  
#  head(PES)

## ----, fig.width= 7, fig.height= 5,eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Display the phylostratum distribution (gene frequency distribution)
#  # of a PhyloExpressionSet as absolute frequency distribution
#  PlotDistribution( PhyloExpressionSet = PhyloExpressionSetExample,
#                    xlab               = "Phylostratum" )

## ----, fig.width= 7, fig.height= 4,eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Plot phylostrata as relative frequency distribution
#  PlotDistribution( PhyloExpressionSet = PhyloExpressionSetExample,
#                    as.ratio           = TRUE,
#                    xlab               = "Phylostratum",
#                    cex                = 0.7 )

## ----, fig.width= 5, fig.height= 4,eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Visualizing the correlation between Phylostratum and Divergence-Stratum assignments
#  # of the intersecting set of genes that are stored within the PhyloExpressionSet
#  # and DivergenceExpressionSet
#  
#  PlotCorrelation( PhyloExpressionSet      = PhyloExpressionSetExample,
#                   DivergenceExpressionSet = DivergenceExpressionSetExample,
#                   method                  = "kendall",
#                   linearModel             = TRUE )

## ----, fig.width= 7, fig.height= 5,eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Plot the Transcriptome Age Index of a given PhyloExpressionSet
#  # Test Statistic : Flat Line Test (default)
#  PlotPattern( ExpressionSet = PhyloExpressionSetExample,
#               type          = "l",
#               lwd           = 6,
#               xlab          = "Ontogeny",
#               ylab          = "TAI" )

## ----, fig.width= 7, fig.height= 5,eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Plot the Transcriptome Age Index of a given PhyloExpressionSet
#  # Test Statistic : Reductive Hourglass Test
#  PlotPattern( ExpressionSet = PhyloExpressionSetExample,
#               TestStatistic = "ReductiveHourglassTest",
#               modules       = list(early = 1:2, mid = 3:5, late = 6:7),
#               type          = "l",
#               lwd           = 6,
#               xlab          = "Ontogeny",
#               ylab          = "TAI" )

## ----, fig.width= 7, fig.height= 5,eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Visualize the phylotypic period used for the Reductive Hourglass Test
#  PlotPattern( ExpressionSet = PhyloExpressionSetExample,
#               TestStatistic = "ReductiveHourglassTest",
#               modules       = list(early = 1:2, mid = 3:5, late = 6:7),
#               shaded.area   = TRUE,
#               type          = "l",
#               lwd           = 6,
#               xlab          = "Ontogeny",
#               ylab          = "TAI" )

## ----, fig.width= 7, fig.height= 5,eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Plot the Transcriptome Age Index of a given PhyloExpressionSet
#  # Test Statistic : Reductive Early Conservation Test
#  PlotPattern( ExpressionSet = PhyloExpressionSetExample,
#               TestStatistic = "EarlyConservationTest",
#               modules       = list(early = 1:2, mid = 3:5, late = 6:7),
#               type          = "l",
#               lwd           = 6,
#               xlab          = "Ontogeny",
#               ylab          = "TAI" )

## ----,eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Compute the Transcriptome Age Index values of a given PhyloExpressionSet
#  TAI(PhyloExpressionSetExample)

## ----, fig.width= 7, fig.height= 5,eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Plot the Transcriptome Divergence Index of a given DivergenceExpressionSet
#  # Test Statistic : Flat Line Test (default)
#  PlotPattern( ExpressionSet = DivergenceExpressionSetExample,
#               type          = "l",
#               lwd           = 6,
#               xlab          = "Ontogeny",
#               ylab          = "TDI" )

## ----, fig.width= 7, fig.height= 5,eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Plot the Transcriptome Divergence Index of a given DivergenceExpressionSet
#  # Test Statistic : Reductive Hourglass Test
#  PlotPattern( ExpressionSet = DivergenceExpressionSetExample,
#               TestStatistic = "ReductiveHourglassTest",
#               modules       = list(early = 1:2, mid = 3:5, late = 6:7),
#               type          = "l",
#               lwd           = 6,
#               xlab          = "Ontogeny",
#               ylab          = "TDI" )

## ----, fig.width= 7, fig.height= 5,eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Plot the Transcriptome Divergence Index of a given DivergenceExpressionSet
#  # Test Statistic : Reductive Early Conservation Test
#  PlotPattern( ExpressionSet = DivergenceExpressionSetExample,
#               TestStatistic = "EarlyConservationTest",
#               modules       = list(early = 1:2, mid = 3:5, late = 6:7),
#               type          = "l",
#               lwd           = 6,
#               xlab          = "Ontogeny",
#               ylab          = "TDI" )

## ----,eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Compute the Transcriptome Divergence Index values of a given DivergenceExpressionSet
#  TDI(DivergenceExpressionSetExample)

## ----, fig.width= 7, fig.height= 5,eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Visualizing the mean gene expression of each Phylostratum class
#  PlotMeans( ExpressionSet = PhyloExpressionSetExample,
#             Groups        = list(1:12),
#             legendName    = "PS",
#             xlab          = "Ontogeny",
#             lty           = 1,
#             cex           = 0.7,
#             lwd           = 5 )

## ----, fig.height= 5, fig.width=9,eval=FALSE--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Visualizing the mean gene expression of each Phylostratum class
#  # in two separate plots (groups)
#  PlotMeans( ExpressionSet = PhyloExpressionSetExample,
#             Groups        = list(group_1 = 1:3, group_2 = 4:12),
#             legendName    = "PS",
#             xlab          = "Ontogeny",
#             lty           = 1,
#             cex           = 0.7,
#             lwd           = 5 )

## ----,eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Using the age.apply() function to compute the mean expression levels
#  # of all Phylostrata
#  age.apply( ExpressionSet = PhyloExpressionSetExample,
#             FUN           = colMeans )

## ----, fig.width= 7, fig.height= 5,eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Visualizing the mean gene expression of each Divergence-Stratum class
#  PlotMeans( ExpressionSet = DivergenceExpressionSetExample,
#             Groups        = list(1:10),
#             legendName    = "DS",
#             xlab          = "Ontogeny",
#             lty           = 1,
#             cex           = 0.7,
#             lwd           = 5 )

## ----,eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Using the age.apply() function to compute the mean expression levels
#  # of all Divergence-Strata
#  age.apply( ExpressionSet = DivergenceExpressionSetExample,
#             FUN           = colMeans )

## ----, fig.width= 7, fig.height= 5,eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Visualizing the mean gene expression of each Phylostratum class
#  PlotRE( ExpressionSet = PhyloExpressionSetExample,
#          Groups        = list(1:10),
#          legendName    = "PS",
#          xlab          = "Ontogeny",
#          lty           = 1,
#          cex           = 0.7,
#          lwd           = 5 )

## ----, fig.width= 7, fig.height= 5,eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Visualizing the mean gene expression of each Divergence-Stratum class
#  PlotRE( ExpressionSet = DivergenceExpressionSetExample,
#          Groups        = list(1:10),
#          legendName    = "DS",
#          xlab          = "Ontogeny",
#          lty           = 1,
#          cex           = 0.7,
#          lwd           = 5 )

## ----,fig.height=5, fig.width=9,eval=FALSE----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Visualizing the mean gene expression of each Phylostratum class
#  PlotRE( ExpressionSet = PhyloExpressionSetExample,
#          Groups        = list(group_1 = 1:3, group_2 = 4:12),
#          legendName    = "PS",
#          xlab          = "Ontogeny",
#          lty           = 1,
#          cex           = 0.7,
#          lwd           = 5 )

## ----,eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Getting the relative expression levels for all Phylostrata
#  REMatrix(PhyloExpressionSetExample)

## ----,eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Getting the relative expression levels for all Divergence-Strata
#  REMatrix(DivergenceExpressionSetExample)

## ----,eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Getting the relative expression levels for all Phylostrata
#  age.apply( ExpressionSet = PhyloExpressionSetExample,
#             FUN           = RE )

## ----,fig.height=5, fig.width=7,eval=FALSE----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Visualizing the mean relative expression of two Phylostratum groups
#  PlotBarRE( ExpressionSet = PhyloExpressionSetExample,
#             Groups        = list(group_1 = 1:3, group_2 = 4:12),
#             xlab          = "Ontogeny",
#             ylab          = "Mean Relative Expression",
#             cex           = 2)

## ----, fig.height=5,fig.width=7,eval=FALSE----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Visualizing the mean relative expression of two Phylostratum groups
#  PlotBarRE( ExpressionSet = PhyloExpressionSetExample,
#             Groups        = list(group_1 = 1:3, group_2 = 4:12),
#             ratio         = TRUE,
#             xlab          = "Ontogeny",
#             ylab          = "Mean Relative Expression",
#             cex           = 2 )

## ----, fig.width=7,eval=FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Visualizing the mean relative expression of three Phylostratum groups
#  PlotBarRE( ExpressionSet = PhyloExpressionSetExample,
#             Groups        = list(group_1 = 1:3, group_2 = 4:6, group_3 = 7:12),
#             wLength       = 0.05,
#             xlab          = "Ontogeny",
#             ylab          = "Mean Relative Expression",
#             cex           = 2 )

## ----, fig.width= 7, fig.height= 5,eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # cex = 0.5, cex.lab = 0.5, cex.axis = 0.5
#  PlotPattern( ExpressionSet = PhyloExpressionSetExample,
#               type          = "l",
#               lwd           = 6,
#               xlab          = "Ontogeny",
#               ylab          = "TAI",
#               cex           = 0.5,
#               cex.lab       = 0.5,
#               cex.axis      = 0.5 )

## ----, fig.width= 7, fig.height= 5,eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # cex = 2, cex.lab = 1, cex.axis = 0.5
#  PlotPattern( ExpressionSet = PhyloExpressionSetExample,
#               type          = "l",
#               lwd           = 6,
#               xlab          = "Ontogeny",
#               ylab          = "TAI",
#               cex           = 2,
#               cex.lab       = 1,
#               cex.axis      = 0.5 )

## ----, fig.width= 7, fig.height= 5,eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # cex = 0.5, cex.lab = 0.7, cex.axis = 1.5
#  PlotPattern( ExpressionSet = PhyloExpressionSetExample,
#               type          = "l",
#               lwd           = 6,
#               xlab          = "Ontogeny",
#               ylab          = "TAI",
#               cex           = 0.5,
#               cex.lab       = 0.7,
#               cex.axis      = 1.5 )

