% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/microstrategy.R
\docType{methods}
\name{get_report}
\alias{get_report}
\alias{get_report,connection-method}
\title{Extracts the contents of a report into a R Data.Frame}
\usage{
get_report(connection, report_id, offset = 0, limit = 1000)

\S4method{get_report}{connection}(connection, report_id, offset = 0,
  limit = 1000)
}
\arguments{
\item{connection}{MicroStrategy REST API connection object}

\item{report_id}{Unique ID of the report you wish to extract information from}

\item{offset}{(optional) To extract all data from the report, use 0 (default)}

\item{limit}{(optional) Used to control data extract behavior on datasets with a large
number of rows. The default is 1000. As an example, if the dataset has 50,000 rows,
\code{get_report()} will incrementally extract all 50,000 rows in 1,000 row chunks. Depending
on system resources, a higher limit (e.g. 10,000) may reduce the total time
required to extract the entire dataset}
}
\value{
R Data.Frame containing the report contents
}
\description{
Extracts the contents of a MicroStrategy report into a R Data.Frame
}
\examples{
\donttest{
# Extract the contents of a report into an R Data.Frame
my_report <- get_report(connection = conn,
                        report_id = "5E2501A411E8756818A50080EF4524C9")

# Extract the contents in larger 'chunks' using limit.
# May require add'l server processing time.
# As a rule-of-thumb, aim for a limit setting around 10\%
# to 20\% of the total number of rows in the report.
my_report <- get_report(connection = conn,
                        report_id = "5E2501A411E8756818A50080EF4524C9",
                        limit = 100000)

# You can also set limit to -1. Use this only on smaller reports.
my_report <- get_report(connection = conn,
                        report_id = "5E2501A411E8756818A50080EF4524C9",
                        limit = -1)
}
}
