% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/place_relations.R
\name{mr_place_relations}
\alias{mr_place_relations}
\title{Related records}
\usage{
mr_place_relations(mrgid, direction = c("upper", "lower", "both"),
  type = c("partof", "partlypartof", "adjacentto", "similarto",
  "administrativepartof", "influencedby", "all"), ...)
}
\arguments{
\item{mrgid}{(numeric) the MRGID (Marineregions Global Identifier) for the
record of interest}

\item{direction}{(character) in which direction of the geographical hierarchy
should the records be retrieved? Default: \code{upper}}

\item{type}{(character) what kind of relations should the records retrieve
have with the place? Default: \code{partof}}

\item{...}{curl options to be passed on to \code{\link[httr]{GET}}}
}
\description{
Get related records based on their MRGID.
}
\examples{
\dontrun{
## geocode to get geospatial data for a place name
(tikehau <- mr_geo_code("tikehau"))

## then pass in in an MRGID as the first parameter
mr_place_relations(tikehau$MRGID)

## Set direction='both'
mr_place_relations(tikehau$MRGID, direction = "both")

## Set type to various other options
mr_place_relations(307, type = "adjacentto")
mr_place_relations(414, type = "similarto")
mr_place_relations(4177, type = "all")
}
}
\author{
Francois Michonneau <francois.michonneau@gmail.com>
}
