% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morphomap3Dmap.R
\name{morphomap3Dmap}
\alias{morphomap3Dmap}
\title{morphomap3Dmap}
\usage{
morphomap3Dmap(
  morphomap.shape,
  out.sur,
  method = "equiangular",
  scale = TRUE,
  rem.out = FALSE,
  fac.out = 0.5,
  smooth = FALSE,
  smooth.iter = 5,
  k = 5,
  plot = TRUE,
  pal = blue2green2red(101)
)
}
\arguments{
\item{morphomap.shape}{list: output from morphomapShape function}

\item{out.sur}{3D mesh: 3D mesh of the long bone}

\item{method}{character: if set on "equiangular" the cortical thickness is meant as the distance of the segment intersecting the external and internal outline starting from the centroid of the section. If set on "closest" the cortical thickness is calculated at each point as the closest distance between external and internal outlines}

\item{scale}{logical: if TRUE the cortical thickness matrix will be scaled from 0 to 1}

\item{rem.out}{logical: if TRUE outliers are identified and removed from thickness matrix}

\item{fac.out}{numeric: parameter to set the threshold in outliers detection}

\item{smooth}{logical: if TRUE the smoothing filter is applied on the thickness matrix}

\item{smooth.iter}{numeric: number of smoothing iterations}

\item{k}{integer: neighbourhood of kd-tree to search the nearest semilandmarks to each vertex}

\item{plot}{logical: if TRUE the 3D map is plotted}

\item{pal}{character vector: colors to be used in the map production}
}
\value{
cols color associated at each vertex of 3D mesh

thickmat thickness matrix after smoothing and outliers removal
}
\description{
Plot a 3D thickness map in four different anatomical views
}
\examples{
\donttest{
#morphomap on a human femur bone
data(HomFem38023)
meshes<-morphomapSegm(HomFem38023, param1=4)
perMesh<-meshes$external
endMesh<-meshes$internal
mech_length<-380.23
rawSections<-morphomapCore(out.sur=perMesh,
inn.sur=endMesh,num.sect=61,
mech.len = mech_length,param1 = 0.5,
radius.fact = 2.5,npovs = 100,clean_int_out = TRUE,
num.points = 500, start = 0.2,end=0.8)
shapeSections<-morphomapShape(rawSections,24,sects_vector=NULL,cent.out="CCA",
delta=0.1, side="left")

#built 3D morphometric map 
bone3Dmap<-morphomap3Dmap(shapeSections, out.sur=perMesh,
                          plot = TRUE,rem.out=TRUE,
                          fac.out=1.5,smooth=TRUE,
                          smooth.iter=5)
#or
library(rgl)
open3d()
shade3d(perMesh,col=bone3Dmap$cols,specular="black")

#morphomap on a chimpanzee femur bone
data(PanFem27713)
meshes<-morphomapSegm(PanFem27713, param1=3)
perMesh<-meshes$external
endMesh<-meshes$internal
mech_length<-277.13
rawSections<-morphomapCore(out.sur=perMesh,
                           inn.sur=endMesh,num.sect=61,mech.len = mech_length, 
                           start = 0.2,end=0.8)
shapeSections<-morphomapShape(rawSections,24,sects_vector=NULL,cent.out="CCA",
delta=0.1, side="left")
#built 3D morphometric map 
bone3Dmap<-morphomap3Dmap(shapeSections, out.sur=perMesh,
                          plot = TRUE,rem.out=TRUE,
                          fac.out=1.5,smooth=TRUE,
                          smooth.iter=5)
#or
library(rgl)
open3d()
shade3d(perMesh,col=bone3Dmap$cols,specular="black")
}
}
\author{
Antonio Profico, Luca Bondioli, Pasquale Raia, Paul O'Higgins, Damiano Marchi
}
