% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{h_check_covar_nesting}
\alias{h_check_covar_nesting}
\title{Ensure Two Models' Covariates Are Nested}
\usage{
h_check_covar_nesting(model_basic, model_augmented)
}
\arguments{
\item{model_basic, model_augmented}{(\code{mmrm_tmb_formula_parts})\cr the
\code{formula_parts} element of an \code{mmrm} model fit.}
}
\value{
\code{"identical"} if \code{model_basic} and \code{model_augmented} have the same
set of covariates. \code{"nesting"} if the covariates of \code{model_basic} are a
subset of the covariates of \code{model_augmented}.
}
\description{
Throws an error if the covariates of \code{model_basic} aren't the same as or a
subset of the covariates of \code{model_augmented}.
}
\details{
For upstream coding brevity, this function accepts the \code{formula_parts}
element of two \code{mmrm} model fits rather than \code{mmrm} objects. Such objects are
of class \code{mmrm_tmb_formula_parts}.
}
\keyword{internal}
